#include "DemoClipPoint.h"

#include <Inventor/nodes/SoEventCallback.h>
#include <Inventor/events/SoKeyboardEvent.h> 
#include <Inventor/manips/SoClipPlaneManip.h>
#include <Inventor/nodes/SoDrawStyle.h>

#include <MeshVizXLM/mapping/nodes/MoDrawStyle.h>
#include <MeshVizXLM/mapping/nodes/MoMaterial.h>
#include <MeshVizXLM/mapping/nodes/MoMeshClipPoint.h>

//---------------------------------------------------------------------
DemoClipPoint::DemoClipPoint() : 
Demo("MeshVizXLM Clip Points",LINE_MESH_UNSTRUCTURED) 
{
}

//---------------------------------------------------------------------
DemoClipPoint::~DemoClipPoint()
{
}

//---------------------------------------------------------------------
void DemoClipPoint::getMeshAttributes(MoDrawStyle*& ds, MoMaterial*& mat, SoDrawStyle*& /*ids*/, SoPickStyle*& ps)
{
  ds = new MoDrawStyle;
  mat = new MoMaterial;
  ds->displayFaces = false;
  ds->displayEdges = true;
  mat->lineColoring = MoMaterial::COLOR;
  mat->lineColor.setValue(SbColor(1.0,1.0,1.0));
  ps = new SoPickStyle;
  ps->style = SoPickStyle::UNPICKABLE;
}

//---------------------------------------------------------------------
void DemoClipPoint::insertRepresentations(SoSeparator* sep)
{
  // Manipulator to move the plane slice plane (as a clip plane)
  SoClipPlaneManip *manip = new SoClipPlaneManip;
  manip->plane.setValue(SbPlane(SbVec3f(1,0,1),5.0f));
  // Turn off clip plane visibility to avoid flickering of plane slice faces.
  manip->on.setValue(FALSE); 
  manip->draggerPosition.setValue(this->getCenter());
  sep->addChild(manip);

  SoDrawStyle* pds = new SoDrawStyle;
  pds->pointSize = 4.0;
  sep->addChild(pds);

  MoDrawStyle* ds = new MoDrawStyle;
  ds->displayPoints = true;
  sep->addChild(ds);

  MoMaterial* mat = new MoMaterial;
  mat->pointColoring = MoMaterial::CONTOURING;
  sep->addChild(mat);

  MoMeshClipPoint* clipPoints = new MoMeshClipPoint;
  clipPoints->colorScalarSetId = 0;
  clipPoints->plane.connectFrom(&manip->plane);
  sep->addChild(clipPoints);
}

