#include <MbSampleMeshBuilder.h>

#include <MeshVizXLM/mapping/MoMeshViz.h>
#include <MeshVizXLM/mapping/nodes/MoMesh.h>
#include <MeshVizXLM/mapping/nodes/MoScalarSetI.h>
#include <MeshVizXLM/mapping/nodes/MoLinearColorMapping.h>
#include <MeshVizXLM/mapping/nodes/MoLevelColorMapping.h>
#include <MeshVizXLM/mapping/nodes/MoCustomColorMapping.h>
#include <MeshVizXLM/mapping/nodes/MoMeshPlaneSlice.h>
#include <MeshVizXLM/mapping/nodes/MoMeshSkin.h>

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoSwitch.h>
#include <Inventor/nodes/SoCube.h>
#include <Inventor/nodes/SoTranslation.h>
#include <Inventor/manips/SoClipPlaneManip.h>
#include <Inventor/nodes/SoEventCallback.h>
#include <Inventor/nodes/SoCallback.h>
#include <Inventor/events/SoKeyboardEvent.h> 

#include <Inventor/STL/iostream>
#include <Inventor/STL/fstream>
#include <Inventor/STL/vector>
using namespace std;

#define NAMESTR "MeshVizXLM Colormap test program"

#if defined(_MSC_VER)
#pragma warning( push )
#pragma warning(disable:4250)
#endif

MbSampleMeshBuilder<MbVec3f,float> meshBuilder;
MbVolumeMeshTetrahedron<MbVec3f,float,MbVec3f>* mesh = &meshBuilder.getMeshTetrahedron(MbVec3ui(2), MbVec3f(0), MbVec3f(10));

void
editColormap(void *userData, SoEventCallback *eventCB)
{
  bool handled = false;
  const SoEvent *ev = eventCB->getEvent();

  MoLevelColorMapping *colMap = (MoLevelColorMapping*) (userData);
  if (colMap) {
    if (SO_KEY_PRESS_EVENT(ev, NUMBER_2))
    {
      SbVec4f colors[2];
      colors[0].setValue(0,0,1,1); 
      colors[1].setValue(1,0,0,1); 
      colMap->colors.setValues(0,2,colors);
      handled = true;

    } 
    else if (SO_KEY_PRESS_EVENT(ev, NUMBER_3) )
    {
      SbVec4f colors[2];
      colors[0].setValue(1,0,0,1); 
      colors[1].setValue(0,0,1,1); 
      colMap->colors.setValues(0,2,colors);
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, NUMBER_4))
    {
      colMap->minThresholdEnable = !colMap->minThresholdEnable.getValue();
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, P))
    {
      colMap->minThresholdValue = colMap->minThresholdValue.getValue() + 0.5f;
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, M))
    {
      colMap->minThresholdValue = colMap->minThresholdValue.getValue() - 0.5f;
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, NUMBER_5))
    {
      colMap->maxThresholdEnable = !colMap->maxThresholdEnable.getValue();
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, O))
    {
      colMap->maxThresholdValue = colMap->maxThresholdValue.getValue() + 0.5f;
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, L))
    {
      colMap->maxThresholdValue = colMap->maxThresholdValue.getValue() - 0.5f;
      handled = true;
    }
  }

  if (handled) 
    eventCB->setHandled();
}

void
switchColormap(void *userData, SoEventCallback *eventCB)
{
  bool handled = false;
  const SoEvent *ev = eventCB->getEvent();

  SoSwitch *colSwitch = (SoSwitch*) (userData);
  if (colSwitch) 
  {
    if (SO_KEY_PRESS_EVENT(ev, NUMBER_1))
    {
      colSwitch->whichChild = 1 - colSwitch->whichChild.getValue();
      handled = true;
    } 
  }

  if (handled) 
    eventCB->setHandled();
}

//-----------------------------------------------------------------------------
int
main(int, char **)
{
  std::cout << "Hit 1 to toggle from level colormap to linear colormap." << std::endl;
  std::cout << "Hit 2 to invert colors." << std::endl;
  std::cout << "Hit 3 to reset the original colors." << std::endl;
  std::cout << "Hit 4 to enable minimum thresholding." << std::endl;
  std::cout << "Hit p/m to increase/decrease minimum threshold." << std::endl;
  std::cout << "Hit 5 to enable maximum thresholding." << std::endl;
  std::cout << "Hit o/l to increase/decrease maximum threshold." << std::endl;

  MbVec3d max = mesh->getGeometry().getMax();
  MbVec3d min = mesh->getGeometry().getMin();

  MbVec3d center = ( max + min )/2.0f;

  // Init viewer
  Widget my_window = SoXt::init(NAMESTR) ;
  if (my_window == NULL) exit(1) ;

  MoMeshViz::init();

  SoSeparator* sep = new SoSeparator;
  
  SoShapeHints * sh = new SoShapeHints;
  sh->vertexOrdering.setValue(SoShapeHints::CLOCKWISE);
  sep->addChild(sh);

  // Manipulator to move the plane slice plane (as a clip plane)
  SoClipPlaneManip *manip = new SoClipPlaneManip;
  manip->plane.setValue(SbPlane(SbVec3f(1,0,1),5.0f));
  // Turn off clip plane visibility to avoid flickering of plane slice faces.
  manip->on.setValue(FALSE); 
  manip->draggerPosition.setValue((SbVec3f((float)center[0],(float)center[1],(float)center[2])));
  sep->addChild(manip);

  MoMesh* moMesh = new MoMesh;
  moMesh->setMesh(mesh);
  sep->addChild(moMesh);

  SoSwitch* colSwitch = new SoSwitch;
  sep->addChild(colSwitch);
  colSwitch->whichChild = 0;

  MoLevelColorMapping* colMap = new MoLevelColorMapping;
  float values1[3] ;
  values1[0] = (float)mesh->getScalarSet(1)->getMin();
  values1[1] = (float)(mesh->getScalarSet(1)->getMax()- mesh->getScalarSet(1)->getMin())/2.0f;
  values1[2] = (float)mesh->getScalarSet(1)->getMax();
  colMap->values.setValues(0,3,values1);
  SbVec4f colors[2];
  colors[0].setValue(1,0,0,1); 
  colors[1].setValue(0,0,1,1); 
  colMap->colors.setValues(0,2,colors);
  colMap->minThresholdEnable = false;
  colMap->minThresholdValue = (values1[2] + values1[0]) / 3.0f;
  colMap->minThresholdColor.setValue(0.4f, 0.4f, 0.4f, 1);
  colMap->maxThresholdEnable = false;
  colMap->maxThresholdValue = 2 * (values1[2] + values1[0]) / 3.0f;
  colMap->maxThresholdColor.setValue(0.5f, 0.5f, 0.5f, 1);
  colSwitch->addChild(colMap);

  MoLinearColorMapping* liColMap = new MoLinearColorMapping;
  float values[2] ;
  values[0] = (float)mesh->getScalarSet(1)->getMin();
  values[1] = (float)mesh->getScalarSet(1)->getMax();
  liColMap->values.setValues(0,2,values);
  liColMap->colors.connectFrom(&colMap->colors);
  liColMap->minThresholdEnable.connectFrom(&colMap->minThresholdEnable);
  liColMap->minThresholdValue.connectFrom(&colMap->minThresholdValue);
  liColMap->minThresholdColor.connectFrom(&colMap->minThresholdColor);
  liColMap->maxThresholdEnable.connectFrom(&colMap->maxThresholdEnable);
  liColMap->maxThresholdValue.connectFrom(&colMap->maxThresholdValue);
  liColMap->maxThresholdColor.connectFrom(&colMap->maxThresholdColor);
  colSwitch->addChild(liColMap);

  SoEventCallback *myCallbackNode1 = new SoEventCallback;
  myCallbackNode1->addEventCallback(SoKeyboardEvent::getClassTypeId(), editColormap, colMap); 
  sep->addChild(myCallbackNode1);

  SoEventCallback *myCallbackNode2 = new SoEventCallback;
  myCallbackNode2->addEventCallback(SoKeyboardEvent::getClassTypeId(), switchColormap, colSwitch); 
  sep->addChild(myCallbackNode2);

  // Scalar Value
  MoScalarSetI *moScalarSetI = new MoScalarSetI;
  moScalarSetI->setScalarSet(mesh->getScalarSet(1));
  sep->addChild(moScalarSetI);

  SoLightModel* lModel = new SoLightModel;
  lModel->model.setValue(SoLightModel::BASE_COLOR);
  sep->addChild(lModel);

  // Cross Section
  MoMeshPlaneSlice *planeSlice = new MoMeshPlaneSlice;
  sep->addChild(planeSlice);
  planeSlice->plane.setValue(SbPlane(SbVec3f(1,0,0),5.0f));
  planeSlice->plane.connectFrom(&manip->plane);
  // Use 
  planeSlice->colorScalarSetId = 0;

  // Transparent Mesh Skin
  SoDrawStyle* style = new SoDrawStyle;
  style->style.setValue(SoDrawStyle::LINES);
  sep->addChild(style);
  SoPickStyle* pickStyle = new SoPickStyle;
  pickStyle->style.setValue(SoPickStyle::UNPICKABLE);
  sep->addChild(pickStyle);

  MoMeshSkin *skin = new MoMeshSkin;
  skin->colorScalarSetId = 0;
  sep->addChild(skin);

  SoXtExaminerViewer* viewer = new SoXtExaminerViewer(my_window);
  viewer->setSceneGraph(sep);
  viewer->setSize(SbVec2s(1024,768));
  viewer->show();
  viewer->viewAll();

  // dialog
  SoXt::show(my_window);
  SoXt::mainLoop();

  delete viewer;

  MoMeshViz::finish();
  SoXt::finish();

  return 0;
}

#if defined(_MSC_VER)
#pragma warning( pop ) 
#endif

