#ifndef _CellFilters_H
#define _CellFilters_H

#include <MeshVizXLM/mesh/cell/MiCellFilterI.h>
#include <MeshVizXLM/mesh/cell/MiCellFilterIj.h>
#include <MeshVizXLM/mesh/cell/MiCellFilterIjk.h>

class CellFilter : public MiCellFilterI, public MiCellFilterIj, public MiCellFilterIjk
{
public:
  CellFilter(const MbVec3<size_t> &meshSize) : m_meshSize(meshSize) {}
  virtual bool acceptCell(size_t index) const
  {
    size_t ij = index % (m_meshSize[0]*m_meshSize[1]);
    size_t j = ij / (m_meshSize[0]);
    size_t i = ij % (m_meshSize[0]);
    return acceptCell(i,j);
  }

  virtual bool acceptCell(size_t i, size_t j) const 
  { 
    if (((m_meshSize[0]/3.0f)<i && i<=(2*m_meshSize[0]/3.0f)) && ((m_meshSize[1]/3.0f)<j && j<=(2*m_meshSize[1]/3.0f))) return false;
    else return true;
  }
  virtual bool acceptCell(size_t i, size_t j, size_t /*k*/) const
  {
    return acceptCell(i,j);
  }

  virtual size_t getTimeStamp() const { return 2; }
private:
  MbVec3<size_t> m_meshSize;
};

#endif

