#ifndef  _Demo_h
#define  _Demo_h

class SoNode;
class SoSeparator;
class SoEventCallback;
class SoPickStyle;
class MoDrawStyle;
class MoMaterial;

#include <MeshVizXLM/MbVec3.h>
#include <MeshVizXLM/extractors/MiExtractorCallback.h>
#include <MeshVizXLM/mapping/MoMeshVizDataMapping.h>
#include <MeshVizXLM/mapping/nodes/MoCellFilter.h>

#include <Inventor/STL/string>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>

#include "MeshData.h"
#include "MeshSceneEditor.h"

#define NUM_CELL_I 11
#define NUM_CELL_J 15
#define NUM_CELL_K 17
static const MbVec3<size_t> s_defaultMeshSize(NUM_CELL_I,NUM_CELL_J,NUM_CELL_K);

class Demo : public MeshData
{
public:
  virtual ~Demo();
  int run();

  /* methods to implement to manage event*/
  virtual void keyPressed(SoEventCallback* /*eventCB*/) {}
  virtual void mouseMoved(SoEventCallback* /*eventCB*/) {}
  virtual void mousePressed(SoEventCallback* /*eventCB*/) {}
  /************************/

  friend void keyboardCallback(void *_this, SoEventCallback *eventCB);

protected:
  enum SwitchMeshType { ALL_TYPES, ALL_TYPES_NO_TETRA, ALL_VOLUME_MESHES, ALL_VOLUME_MESHES_NO_TETRA, ALL_SURFACE_MESHES,
                        ALL_SURFACE_VOLUME_MESHES, ALL_IJK_MESHES, ALL_LINE_MESHES, NONE };
  // constructor when using meshes from the MbSampleMeshBuilder
  Demo(const std::string& demoTitle, MeshType meshType, SwitchMeshType switchMeshType = NONE, 
    bool toggleFilter = false, MiDataSet::DataBinding binding = MiDataSet::PER_NODE, 
    const MbVec3<size_t>& meshSize = s_defaultMeshSize);
  // constructor when using specific meshes (must implement methods from class MeshData)
  Demo(const std::string& demoTitle);

  SbVec3f getCenter() const { return m_meshEditor->getCenter(); }

  // edit mesh depending on the eventCB (can be overloaded if needed)
  virtual void editInputMesh(SoEventCallback *eventCB);
  // call this when MeshData contains new data (for instance in keyPressed)
  // mesh and tessellator are re-inserted in scenegraph only if boolean are true
  void setMeshData(bool setMesh = true, bool setTess = true);
  void viewAll();

  // call this method to connect a mesh to the main mesh representation
  // (either skin or surface depending on the type of mesh);
  void connectToMeshRepresentation(MoMesh* mesh) const;

  // inner callback for extraction that can be set on a representation node
  class ExtractorCallback : public MiExtractorCallback
  {
    size_t m_count;
  public:
    ExtractorCallback() : m_count(0) {} 
    void beginExtract(const std::string name, bool geomChanged, bool topoChanged, bool dataSetChanged, size_t) 
    {
      ++m_count;
      if(topoChanged || geomChanged)
        std::cout << name << (topoChanged ? " topology" : "")
                  << (topoChanged && geomChanged ? " and" : "")
                  << (geomChanged ? " geometry" : "") << " extraction started." << std::endl;
      if(dataSetChanged)
        std::cout << name <<" dataset extraction started." << std::endl;
    }
    void endExtract()
    {
      --m_count;
      std::cout << "extraction finished." << std::endl;
      if (m_count == 0) std::cout << std::endl;
    }
    bool beginPhase(size_t , std::string , size_t ) { return true; }
    bool endPhase() { return true; }
    bool endStep(size_t ) { return true; }
    double getEndStepCallPeriod() { return 1.0; }
  };
  ExtractorCallback m_extractorCB;

private:
  SoNode* buildSceneGraph(); 

  /* optional methods to implement */
  // Demo instructions (should return true if instruction are display by this method) 
  virtual bool displayInstructions() const { return false; }
  // 3D View
  // mesh skin attributes
  virtual void getMeshAttributes(MoDrawStyle*& /*ds*/, MoMaterial*& /*mat*/, SoDrawStyle*& /*ids*/, SoPickStyle*& /*ps*/) {}
  // mesh skin extraction callback
  virtual MiExtractorCallback* getExtractorCallback() { return NULL; }
  // insert representations to test (other than skin or surface)
  virtual void insertRepresentations(SoSeparator* /*sep*/) {}
  // 2D View (possible use of TextSceneEditor for instance)
  virtual void insertScene2D(SoSeparator* /*sep*/) {}
  /************************/

  void displayMenu() const;
  void displayMeshSwitch() const;
  void insertInputMesh(SoSeparator* sep);

  std::string m_demoTitle;

  MeshSceneEditor* m_meshEditor;
  SwitchMeshType m_switchMeshType;
  bool           m_toggleFiltering;

  // scene viewer
  SoXtExaminerViewer* m_viewer;
};

#endif 


