#include "MeshData.h"

#include <Inventor/STL/iostream>
#include <Inventor/STL/sstream>
using namespace std;

//------------------------------------------------------------------------
MeshData::MeshData(MeshType meshType, const MbVec3<size_t>& meshSize, MiDataSet::DataBinding binding) : 
  m_meshI(NULL), m_meshIj(NULL), m_meshIjk(NULL), 
  m_cellFilter(meshSize), m_dataBinding(binding),
  m_meshType(meshType), m_defaultMeshSize(meshSize),
  m_numMeshFaults(2,2,0)
{
  m_dataSetName = binding == MiDataSet::PER_NODE ? "$Sphere" : "$CellId";
}

//------------------------------------------------------------------------
MeshData::~MeshData()
{
}

//------------------------------------------------------------------------
const MiMesh* MeshData::getInputMesh(MeshType& meshType)
{
  m_meshI = NULL;
  m_meshIj = NULL;
  m_meshIjk = NULL;
  const MiMesh* mesh;
  meshType = m_meshType;
  switch(m_meshType)
  {
  case VOLUME_MESH_UNSTRUCTURED:
    {
      cout << "Displaying Hexahedron mesh" << endl;
      mesh = m_meshI = &m_meshBuilder.getMeshHexahedron(m_defaultMeshSize,MbVec3d(0),MbVec3d(m_defaultMeshSize));
      break;
    }
  case VOLUME_MESH_REGULAR:
    {
      cout << "Displaying Regular Volume mesh" << endl;
      mesh = m_meshIjk = &m_meshBuilder.getVolumeMeshRegular<STORAGE_LAYOUT>(m_defaultMeshSize,MbVec3d(0),MbVec3d(m_defaultMeshSize));
      break;
    }
  case VOLUME_MESH_RECTILINEAR:
    {
      cout << "Displaying Rectilinear Volume mesh" << endl;
      mesh = m_meshIjk = &m_meshBuilder.getVolumeMeshRectilinear<STORAGE_LAYOUT>(m_defaultMeshSize,MbVec3d(0),MbVec3d(m_defaultMeshSize));
      break;
    }
  case VOLUME_MESH_CURVILINEAR:
    {
      cout << "Displaying Curvilinear Volume mesh" << endl;
      mesh = m_meshIjk= &m_meshBuilder.getVolumeMeshCurvilinear<STORAGE_LAYOUT>(m_defaultMeshSize,MbVec3d(0),MbVec3d(m_defaultMeshSize));
      break;
    }
  case HEXAHEDRON_MESH_IJK:
    {
      cout << "Displaying Vertex Hexahedron IJK mesh" << endl;
      mesh = m_meshIjk = &m_meshBuilder.getVertexHexahedronMeshIjk<STORAGE_LAYOUT>(m_defaultMeshSize,MbVec3d(0),MbVec3d(m_defaultMeshSize), m_numMeshFaults);
      break;
    }
  case VOLUME_MESH_HEXAHEDRON_IJK:
    {
      cout << "Displaying Hexahedron IJK mesh" << endl;
      MbHexahedronMeshIjk<MbVec3d,double,MbVec3d,STORAGE_LAYOUT>& hexaIjk = m_meshBuilder.getHexahedronMeshIjk<STORAGE_LAYOUT>(m_defaultMeshSize,MbVec3d(0),MbVec3d(m_defaultMeshSize), m_numMeshFaults);
      mesh = m_meshI = &hexaIjk;
      m_meshIjk = &hexaIjk;
      break;
    }
  case SURFACE_MESH_UNSTRUCTURED:
    {
      cout << "Displaying Quadrangle mesh" << endl;
      mesh = m_meshI = &m_meshBuilder.getSurfaceMeshQuadrangle(m_defaultMeshSize[0],m_defaultMeshSize[1],MbVec3d(0),MbVec3d(1,0,0),MbVec3d(0,1,0));
      break;
    }
  case SURFACE_MESH_REGULAR:
    {
      cout << "Displaying Regular Surface mesh" << endl;
      mesh = m_meshIj = &m_meshBuilder.getSurfaceMeshRegular(m_defaultMeshSize[0],m_defaultMeshSize[1],MbVec3d(0),MbVec3d((double)m_defaultMeshSize[0],(double)m_defaultMeshSize[1],0));
      break;
    }
  case SURFACE_MESH_RECTILINEAR:
    {
      cout << "Displaying Rectilinear Surface mesh" << endl;
      mesh = m_meshIj = &m_meshBuilder.getSurfaceMeshRectilinear(m_defaultMeshSize[0],m_defaultMeshSize[1],0.0,0.0,(double)m_defaultMeshSize[0],(double)m_defaultMeshSize[1]);
      break;
    }
  case SURFACE_MESH_CURVILINEAR :
    {
      cout << "Displaying Curvilinear Surface mesh" << endl;
      mesh = m_meshIj = &m_meshBuilder.getSurfaceMeshCurvilinear(m_defaultMeshSize[0],m_defaultMeshSize[1],MbVec3d(0),MbVec3d(1,0,0),MbVec3d(0,1,0));
      break;
    }
  case LINE_MESH_UNSTRUCTURED :
    {
      cout << "Displaying Unstructured Line mesh" << endl;
      mesh = m_meshI = &m_meshBuilder.getLineMeshUnstructured(m_defaultMeshSize[0],MbVec3d(0),MbVec3d(m_defaultMeshSize));
      break;
    }
  case LINE_MESH_CURVILINEAR :
    {
      cout << "Displaying Curvilinear Line mesh" << endl;
      mesh = m_meshI = &m_meshBuilder.getLineMeshCurvilinear(m_defaultMeshSize[0],MbVec3d(0),MbVec3d(m_defaultMeshSize));
      break;
    }
  default:
    {
      cout << "Displaying Tetrahedon mesh" << endl;
      mesh = m_meshI = &m_meshBuilder.getMeshTetrahedron(m_defaultMeshSize,MbVec3d(0),MbVec3d(m_defaultMeshSize));
      break;
    }
  }
  return mesh;
}

//------------------------------------------------------------------------
const MbScalardSet* MeshData::getScalarSet(const std::string& name) const
{
  const MbScalardSet* scalarset = NULL;
  if (m_meshI && (m_meshType != VOLUME_MESH_HEXAHEDRON_IJK || m_dataBinding == MiDataSet::PER_NODE))
    scalarset = m_meshI->getScalarSet(name);
  else if (m_meshIj)
    scalarset = m_meshIj->getScalarSet(name);
  else if (m_meshIjk)
    scalarset = m_meshIjk->getScalarSetIjk(name);
  return scalarset;
}

//------------------------------------------------------------------------
const MbScalardSetI* MeshData::getScalarSetI()
{
  return (m_meshI != NULL) ? m_meshI->getScalarSet(m_dataSetName) : NULL;
}

//------------------------------------------------------------------------
const MbScalardSetIj* MeshData::getScalarSetIj()
{
  return (m_meshIj != NULL) ? m_meshIj->getScalarSet(m_dataSetName) : NULL;
}

//------------------------------------------------------------------------
const MbScalardSetIjk* MeshData::getScalarSetIjk()
{
  return (m_meshIjk != NULL) ? m_meshIjk->getScalarSetIjk(m_dataSetName) : NULL;
}

//------------------------------------------------------------------------
const MiVec3dSetI* MeshData::getVec3dSetI()
{
  return (m_meshI != NULL) ? m_meshI->getVec3Set("$MyGeometry") : NULL;
}

//------------------------------------------------------------------------
const MiVec3dSetIj* MeshData::getVec3dSetIj()
{
  return (m_meshIj != NULL) ? m_meshIj->getVec3Set("$MyGeometry") : NULL;
}

//------------------------------------------------------------------------
const MiVec3dSetIjk* MeshData::getVec3dSetIjk()
{
  return (m_meshIjk != NULL) ? m_meshIjk->getVec3SetIjk("$MyGeometry") : NULL;
}

