#ifndef  _MeshData_h
#define  _MeshData_h

#include <MeshVizXLM/MbVec3.h>
#include <MeshVizXLM/mapping/MoMeshVizDataMapping.h>
#include <MbSampleMeshBuilder.h>

#include "Vec3Set.h"
#include "CellFilters.h"

static const MiMeshIjk::StorageLayout STORAGE_LAYOUT = MiMeshIjk::LAYOUT_KJI;

class MiTessellator;
class MiCellFilterI;

class MeshData
{
public:
  MeshData(MeshType meshType, const MbVec3<size_t>& meshSize, MiDataSet::DataBinding binding);
  virtual ~MeshData();

  /* methods to implement to define input data */
  // default is using the MbSampleMeshBuilder
  virtual const MiMesh* getInputMesh(MeshType& meshType);
  virtual const MbScalardSet* getScalarSet(const std::string& name) const;
  virtual       MiTessellator* getTessellator() { return NULL; }

  // data for unstructured mesh
  virtual const MbScalardSetI* getScalarSetI();
  virtual const MiVec3dSetI* getVec3dSetI();
  virtual       MiCellFilterI* getCellFilterI() { return &m_cellFilter; }

  // data for structured surface mesh
  virtual const MbScalardSetIj* getScalarSetIj();
  virtual const MiVec3dSetIj* getVec3dSetIj();
  virtual       MiCellFilterIj* getCellFilterIj() { return &m_cellFilter; }

  // data for structured volume mesh
  virtual const MbScalardSetIjk* getScalarSetIjk();
  virtual const MiVec3dSetIjk* getVec3dSetIjk();
  virtual       MiCellFilterIjk* getCellFilterIjk() { return &m_cellFilter; }
  /************************/

private:
  // members for default data using MbSampleMeshBuilder
  MbSampleMeshBuilder<> m_meshBuilder;
  const MbMesh<MbVec3d,double,MbVec3d>* m_meshI;
  const MbMeshIj<double,MbVec3d>* m_meshIj;
  const MbMeshIjk<double,MbVec3d,STORAGE_LAYOUT>* m_meshIjk;
  CellFilter m_cellFilter;
  MiDataSet::DataBinding m_dataBinding;
  std::string m_dataSetName;

protected:
  // members for default data using MbSampleMeshBuilder
  MeshType       m_meshType;
  MbVec3<size_t> m_defaultMeshSize;
  MbVec3<size_t> m_numMeshFaults; //only for hexahedronIjkMesh
};

#endif 


