#ifndef  _MeshSceneEditor_h
#define  _MeshSceneEditor_h

#include <MeshVizXLM/MbVec3.h>
#include <MeshVizXLM/mapping/MoMeshVizDataMapping.h>
#include <MeshVizXLM/mapping/nodes/MoMesh.h>
#include <MeshVizXLM/mapping/nodes/MoCellFilter.h>
#include <MeshVizXLM/mapping/nodes/MoScalarSetI.h>
#include <MeshVizXLM/mapping/nodes/MoScalarSetIj.h>
#include <MeshVizXLM/mapping/nodes/MoScalarSetIjk.h>
#include <MeshVizXLM/mapping/nodes/MoVec3SetI.h>
#include <MeshVizXLM/mapping/nodes/MoVec3SetIj.h>
#include <MeshVizXLM/mapping/nodes/MoVec3SetIjk.h>
#include <MeshVizXLM/mapping/nodes/MoPredefinedColorMapping.h>
#include <MeshVizXLM/mesh/geometry/MiGeometryI.h>

class SoSwitch;
class SoPickStyle;
class MoTessellator;
class MoDrawStyle;
class MoMaterial;
class MoDataBinding;
class MiExtractorCallback;
class MiCellFilter;

class MeshData;

#if defined(_MSC_VER)
#pragma warning( push )
#pragma warning(disable:4250)
#endif

//------------------------------------------------------------------------
class MeshSceneEditor
{
private:
  MoTessellator*  m_tessellator;
  MoCellFilter*   m_cellFilter;
  MoMesh*         m_meshNode;
  MoScalarSetI*   m_scalarSetINode;
  MoScalarSetIj*  m_scalarSetIjNode;
  MoScalarSetIjk* m_scalarSetIjkNode;
  MoVec3SetI*     m_vec3SetINode;
  MoVec3SetIj*    m_vec3SetIjNode;
  MoVec3SetIjk*   m_vec3SetIjkNode;
  MoPredefinedColorMapping* m_colorMapNode;
  MoDataBinding*  m_binding;

  SoSwitch* m_displaySwitch;
  SoSwitch* m_filterSwitch;

  MbVec3d m_meshCenter;

  void clear();
  template< typename _MeshT, typename _ScalarSetT, typename _ScalarSetNodeT, typename _Vec3SetT, typename _Vec3SetNodeT>
  void set(const _MeshT* mesh, const _ScalarSetT* scalarSet, _ScalarSetNodeT* scalarNode,
           const _Vec3SetT* vec3Set, _Vec3SetNodeT* vec3Node, MiCellFilter* cellFilter);

  void setDisplay(MeshType meshType);

public:
  MeshSceneEditor(SoSeparator* mainScene, MoDrawStyle* ds = NULL, MoMaterial* mat = NULL, SoDrawStyle* sods = NULL, SoPickStyle* ps = NULL, MiExtractorCallback* cb = NULL);
  void edit(MeshData* data, bool setMesh = true, bool setTess = true);
  void disableFiltering();
  void toggleFiltering();
  void connectTo(MoMesh* mesh) const;
  SbVec3f getCenter() const 
  {
    return SbVec3f((float)m_meshCenter[0],(float)m_meshCenter[1],(float)m_meshCenter[2]);
  }
};

//------------------------------------------------------------------------
template< typename _MeshT, typename _ScalarSetT, typename _ScalarSetNodeT, typename _Vec3SetT, typename _Vec3SetNodeT>
inline void MeshSceneEditor::set(const _MeshT* mesh, const _ScalarSetT* scalarSet, _ScalarSetNodeT* scalarNode,
                          const _Vec3SetT* vec3Set, _Vec3SetNodeT* vec3Node, MiCellFilter* cellFilter)
{
  m_meshNode->setMesh(mesh);
  const MiGeometry& geometry = mesh->getGeometry();
  try
  {
    m_meshCenter = (geometry.getMax() + geometry.getMin()) / 2.0;
  }
  catch(MiAbstractMethodError e)
  {
    m_meshCenter.setValue(0,0,0);
  }
  scalarNode->setScalarSet(scalarSet);
  if (scalarSet)
  {
    m_colorMapNode->minValue = (float)scalarSet->getMin();
    m_colorMapNode->maxValue = (float)scalarSet->getMax();
  }
  vec3Node->setVec3Set(vec3Set);
  m_cellFilter->setCellFilter(cellFilter);
}

#if defined(_MSC_VER)
#pragma warning( pop ) 
#endif

#endif


