#include "TextSceneEditor.h"

#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoSwitch.h>
#include <Inventor/nodes/SoTranslation.h>

#include <Inventor/nodes/SoAnnotation.h>
#include <Inventor/nodes/SoRotation.h>
#include <Inventor/nodes/SoText2.h>

#include <Inventor/STL/iostream>
#include <Inventor/STL/sstream>
using namespace std;

const char* TextSceneEditor::s_meshTypeName[15] = { "Unstructured Volume Mesh",
                                                    "Unstructured IJK Volume Mesh",
                                                    "Unstructured IJK Hexahedron Mesh",
                                                    "Unstructured IJK Hexahedron Mesh",
                                                    "Regular Volume Mesh",
                                                    "Rectilinear Volume Mesh",
                                                    "Curvilinear Volume Mesh",
                                                    "Unstructured Surface Mesh",
                                                    "Regular Surface Mesh",
                                                    "Rectilinear Surface Mesh",
                                                    "Curvilinear Surface Mesh",
                                                    "Unstructured Line Mesh",
                                                    "Regular Line Mesh",
                                                    "Curvilinear Line Mesh",
                                                    "Mesh not defined" };

//------------------------------------------------------------------------
TextSceneEditor::TextSceneEditor(SoSeparator* textScene) 
{
  // Text display
  SoSeparator* cellTextSep = new SoSeparator;

  SoTranslation *trans1 = new SoTranslation;
  trans1->translation.setValue(-0.95F, 0.95F, -1.F);

  m_indexText = new SoText2;
  m_indexText->justification = SoText2::LEFT;

  SoTranslation *trans2 = new SoTranslation;
  trans2->translation.setValue(0.F, -0.05F, 0);
  m_scalarText = new SoText2;
  m_scalarText->justification = SoText2::LEFT;
  m_vectorText = new SoText2;
  m_vectorText->justification = SoText2::LEFT;

  SoSeparator* meshTextSep = new SoSeparator;

  SoTranslation *trans3 = new SoTranslation;
  trans3->translation.setValue(-0.95F, -0.90F, -1.F);

  m_meshText = new SoText2;
  m_meshText->justification = SoText2::LEFT;
  m_colorText = new SoText2;
  m_colorText->justification = SoText2::LEFT;
  
  m_displaySwitch = new SoSwitch;
  m_displaySwitch->whichChild = SO_SWITCH_NONE;

  SoAnnotation *annotation = new SoAnnotation;
  annotation->fastEditing = SoSeparator::KEEP_ZBUFFER;
  textScene->addChild(annotation);
  {
    annotation->addChild(m_displaySwitch);
    {
      m_displaySwitch->addChild(cellTextSep);
      {
        cellTextSep->addChild(trans1);
        cellTextSep->addChild(m_indexText);
        cellTextSep->addChild(trans2);
        cellTextSep->addChild(m_scalarText);
        cellTextSep->addChild(trans2);
        cellTextSep->addChild(m_vectorText);
      }
      m_displaySwitch->addChild(meshTextSep);
      {
        meshTextSep->addChild(trans3);
        meshTextSep->addChild(m_meshText);
        meshTextSep->addChild(trans2);
        meshTextSep->addChild(m_colorText);
      }
    }
  }
}

//------------------------------------------------------------------------
void TextSceneEditor::edit(size_t* cellIds, size_t num, double scalar, const MbVec3d* vector, MeshType meshType, const std::string& colorName)
{
  if (cellIds[0] == std::numeric_limits<size_t>::max())
    m_displaySwitch->whichChild = SO_SWITCH_NONE;
  else
  {
    m_displaySwitch->whichChild = SO_SWITCH_ALL;

    std::ostringstream str1;
    str1 << "cell: ";
    for (size_t i = 0; i < num; ++i)
      str1 << cellIds[i] << " ";
    m_indexText->string = str1.str();

    std::ostringstream str2;
    str2.width(2);
    str2 << "value: " << scalar;
    m_scalarText->string = str2.str();

    std::ostringstream str3;
    if (vector)
      str3 << "vector: " << *vector;
    m_vectorText->string = str3.str();

    m_meshText->string.setNum(0);
    m_colorText->string.setNum(0);

    if ( meshType != UNDEFINED_MESH)
    {
      SbString meshString = "MeshType: ";
      meshString += s_meshTypeName[meshType];
      m_meshText->string = meshString;
    }

    if (colorName != "")
    {
      SbString colorString = "ColorName: ";
      colorString += colorName;
      m_colorText->string = colorString;
    }
  }
}

