#ifndef  _TextSceneEditor_h
#define  _TextSceneEditor_h

#include <Inventor/nodes/SoSwitch.h>
#include <Inventor/nodes/SoText2.h>
#include <MeshVizXLM/mapping/MoMeshVizDataMapping.h>
#include <MeshVizXLM/MbVec3.h>

#if defined(_MSC_VER)
#pragma warning( push )
#pragma warning(disable:4250)
#endif

//------------------------------------------------------------------------
class TextSceneEditor
{
private:
  SoSwitch* m_displaySwitch;
  SoText2* m_indexText;
  SoText2* m_scalarText;
  SoText2* m_vectorText;
  SoText2* m_meshText;
  SoText2* m_colorText;
  
  void edit(size_t* cellIds, size_t num, double scalar, const MbVec3d* vector = NULL, MeshType meshType = UNDEFINED_MESH, const std::string& colorName ="");

  static const char* s_meshTypeName[15];

public:
  TextSceneEditor(SoSeparator* textScene);
  
  void clear()
  {
    size_t cellId = -1;
    edit(&cellId,1,0);
  }
  void edit(size_t cellId, double scalar, MeshType meshType, const std::string& colorName)
  {
    edit(&cellId, 1, scalar, NULL, meshType, colorName);
  }
  void edit(size_t* cellIds, size_t num, double scalar, MeshType meshType, const std::string& colorName)
  {
    edit(cellIds, num, scalar, NULL, meshType, colorName);
  }

  void edit(size_t* cellIds, size_t num, double scalar, const MbVec3d& vector)
  {
    edit(cellIds, num, scalar, &vector);
  }

  void edit(size_t cellIds, double scalar, const MbVec3d& vector)
  {
    edit(&cellIds, 1, scalar, &vector);
  }

};

#if defined(_MSC_VER)
#pragma warning( pop ) 
#endif

#endif


