#include <MbSampleMeshBuilder.h>
#include <MeshVizXLM/extractors/MiExtractorCallback.h>

#include <colormapping/MbLinearColorMapping.h>
#include <colormapping/MbLevelColorMapping.h>

#include <MeshVizXLM/mapping/MoMeshViz.h>
#include <MeshVizXLM/mapping/nodes/MoMesh.h>
#include <MeshVizXLM/mapping/nodes/MoScalarSetI.h>
#include <MeshVizXLM/mapping/nodes/MoPredefinedColorMapping.h>
#include <MeshVizXLM/mapping/nodes/MoCustomColorMapping.h>
#include <MeshVizXLM/mapping/nodes/MoMeshElevatedPlaneSlice.h>
#include <MeshVizXLM/mapping/nodes/MoMeshOutline.h>
#include <MeshVizXLM/mapping/nodes/MoDrawStyle.h>
#include <MeshVizXLM/mapping/nodes/MoMaterial.h>
#include <MeshVizXLM/mapping/nodes/MoCellFilter.h>

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoCube.h>
#include <Inventor/nodes/SoTranslation.h>
#include <Inventor/manips/SoClipPlaneManip.h>
#include <Inventor/draggers/SoJackDragger.h>
#include <Inventor/nodes/SoEventCallback.h>
#include <Inventor/nodes/SoCallback.h>
#include <Inventor/events/SoKeyboardEvent.h> 
#include <Inventor/nodes/SoSwitch.h>

#include <Inventor/STL/iostream>
#include <Inventor/STL/fstream>
#include <Inventor/STL/vector>
using namespace std;

#define NAMESTR "MeshVizXLM Sample program"

#if defined(_MSC_VER)
#pragma warning( push )
#pragma warning(disable:4250)
#endif

#define NUM_CELL_I 9

#include <MeshVizXLM/mesh/cell/MiCellFilterI.h>
class MyCellFilter : public MiCellFilterI
{
public:
  virtual bool acceptCell(size_t i) const
  {
    // Compute any random function
    if ( i < (NUM_CELL_I/2.0) ) return false;
    else return true;
  }
  virtual size_t getTimeStamp() const { return 0; }
};

class MyExtractorCallback : public MiExtractorCallback
{
public:
  void beginExtract(const std::string, bool, bool topoChanged, bool dataSetChanged, size_t) 
  {
    if(topoChanged)
      std::cout << "shape computation ..." << endl;
    if(dataSetChanged)
      std::cout << "dataset computation started..." << endl;
  }
  void endExtract()
  {
    std::cout << "computation finished" << endl;
  }
  bool beginPhase(size_t , std::string , size_t ) { return true; }
  bool endPhase() { return true; }
  bool endStep(size_t ) { return true; }
  double getEndStepCallPeriod() { return 1.0; }

};

//-------------------------------------------------------------------------------------
// callback called when the field manip->plane has changed
// void draggerMotionCB(void *data, SoSensor* sensor)
// {
//   MoMeshCylinderSlice *cylinderSlice = (MoMeshCylinderSlice *) data;
//   const SoSFPlane* plane = (SoSFPlane*) ((SoFieldSensor*)sensor)->getAttachedField();
//   if(cylinderSlice)
//   {
//     cylinderSlice->direction.setValue(plane->getValue().getNormal());
//   }
// }

void
editExtrusion(void *userData, SoEventCallback *eventCB)
{
  const SoEvent *ev = eventCB->getEvent();

  bool handled = false;

  MoMeshElevatedPlaneSlice *plane = (MoMeshElevatedPlaneSlice*) userData;
  if (plane) {
    if (SO_KEY_PRESS_EVENT(ev, NUMBER_0) || SO_KEY_PRESS_EVENT(ev, PAD_0))
    {
      plane->elevationScalarSetId = 0;
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, NUMBER_1) || SO_KEY_PRESS_EVENT(ev, PAD_1))
    {
      plane->elevationScalarSetId = 1;
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, UP_ARROW))
    {
      double val = plane->scaleFactor.getValue();
      plane->scaleFactor.setValue( val + 0.1 );
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, DOWN_ARROW))
    {
      double val = plane->scaleFactor.getValue();
      plane->scaleFactor.setValue( val - 0.1 );
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, LEFT_ARROW))
    {
      plane->colorScalarSetId = 0;
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, RIGHT_ARROW))
    {
      plane->colorScalarSetId = 1;
      handled = true;
    }
  }

  if (handled) 
    eventCB->setHandled();
}

void
editSwitch(void *userData, SoEventCallback *eventCB)
{
  bool handled = false;
  const SoEvent *ev = eventCB->getEvent();

  SoSwitch *theSwitch = (SoSwitch*) (userData);
  if (theSwitch) {
    if (SO_KEY_PRESS_EVENT(ev, F))
    {
      theSwitch->whichChild = (theSwitch->whichChild.getValue() == SO_SWITCH_NONE) ? SO_SWITCH_ALL : SO_SWITCH_NONE;
    }
  }
  if (handled)
    eventCB->setHandled();
}

//-----------------------------------------------------------------------------
int
main(int, char **)
{
  MbSampleMeshBuilder<MbVec3f,float> meshBuilder;
  MbVolumeMeshHexahedron<MbVec3f,float,MbVec3f>* mesh = &meshBuilder.getMeshHexahedron(MbVec3<size_t>(3),MbVec3f(0),MbVec3f(10));

  cout << "Press up arrow for increasing scale factor" << endl;
  cout << "Press down arrow for decreasing scale factor" << endl;
  cout << "Press 0 for displaying an extruded plane slice on a dataset with per cell binding" << endl;
  cout << "Press 1 for displaying an extruded plane slice on a dataset with per node binding" << endl;
  cout << "Press left arrow for displaying an extruded plane slice with a color dataset with per cell binding" << endl;
  cout << "Press right arrow for displaying an extruded plane slice with a color dataset with per node binding" << endl;
  cout << "Press f to enable/disable the cell filter" << endl;

  MbVec3d max = mesh->getGeometry().getMax();
  MbVec3d min = mesh->getGeometry().getMin();

  MbVec3d center = ( max + min )/2.0f;

  // Init viewer
  Widget my_window = SoXt::init(NAMESTR) ;
  if (my_window == NULL) exit(1) ;

  MoMeshViz::init();

  SoSeparator* sep = new SoSeparator;
  
  SoShapeHints * sh = new SoShapeHints;
  sh->vertexOrdering.setValue(SoShapeHints::CLOCKWISE);
  sep->addChild(sh);

  // Manipulator to move the plane slice plane (as a clip plane)
  SoClipPlaneManip *manip = new SoClipPlaneManip;
  manip->plane.setValue(SbPlane(SbVec3f(0,0,1),5.0f));
  // Turn off clip plane visibility to avoid flickering of plane slice faces.
  manip->on.setValue(FALSE); 
  manip->draggerPosition.setValue((SbVec3f((float)center[0],(float)center[1],(float)center[2])));
  sep->addChild(manip);

  MoMesh* moMesh = new MoMesh;
  moMesh->setMesh(mesh);
  sep->addChild(moMesh);

  MoPredefinedColorMapping* colMap = new MoPredefinedColorMapping;
  colMap->minValue = (float)mesh->getScalarSet(0)->getMin();
  colMap->maxValue = (float)mesh->getScalarSet(0)->getMax();
  colMap->predefColorMap = MoPredefinedColorMapping::BLUE_RED;
  sep->addChild(colMap);

  // Color Scalar Value
  MoScalarSetI *MoScalarSetI1 = new MoScalarSetI;
  MoScalarSetI1->setScalarSet(mesh->getScalarSet(0));
  sep->addChild(MoScalarSetI1);

  // Elevation Scalar Value
  MoScalarSetI *MoScalarSetI2 = new MoScalarSetI;
  MoScalarSetI2->setScalarSet(mesh->getScalarSet(1));
  sep->addChild(MoScalarSetI2);

  SoSwitch* cellFilterSwitch = new SoSwitch;
  cellFilterSwitch->whichChild = SO_SWITCH_NONE;
  sep->addChild(cellFilterSwitch);
  MoCellFilter* cellFilter = new MoCellFilter;
  cellFilter->setCellFilter(new MyCellFilter);
  cellFilterSwitch->addChild(cellFilter);

  MyExtractorCallback callback;

  // Extruded plane slice
  MoMeshElevatedPlaneSlice *extrudedSlice = new MoMeshElevatedPlaneSlice;
  sep->addChild( extrudedSlice );
  extrudedSlice->plane.connectFrom( &manip->plane );
  // Use data set 0 for coloring
  extrudedSlice->colorScalarSetId = 0;
  // Use the same data set for elevation
  extrudedSlice->elevationScalarSetId = 1;
  // Set the scale factor for extrusion
  extrudedSlice->scaleFactor.setValue( 0.1 );
  extrudedSlice->setExtractorCallback( &callback );

  SoEventCallback *myCallbackNode1 = new SoEventCallback;
  myCallbackNode1->addEventCallback(SoKeyboardEvent::getClassTypeId(), editExtrusion, extrudedSlice); 
  sep->addChild(myCallbackNode1);

  SoEventCallback *myCallbackNode2= new SoEventCallback;
  myCallbackNode2->addEventCallback(SoKeyboardEvent::getClassTypeId(), editSwitch, cellFilterSwitch);
  sep->addChild(myCallbackNode2);

  MoDrawStyle* style2 = new MoDrawStyle;
  style2->displayFaces = FALSE;
  style2->displayEdges = TRUE;
  sep->addChild(style2);
  MoMaterial* material2 = new MoMaterial;
  material2->lineColoring = MoMaterial::CONTOURING;
  sep->addChild(material2);

  SoPickStyle* pickStyle = new SoPickStyle;
  pickStyle->style.setValue(SoPickStyle::UNPICKABLE);
  sep->addChild(pickStyle);

  MoMeshOutline *outline = new MoMeshOutline;
  outline->colorScalarSetId = 0;
  sep->addChild(outline);

  SoXtExaminerViewer* viewer = new SoXtExaminerViewer(my_window);
  viewer->setSceneGraph(sep);
  viewer->setSize(SbVec2s(1024,768));
  viewer->show();
  viewer->viewAll();

  // dialog
  SoXt::show(my_window);
  SoXt::mainLoop();

  delete viewer;

  MoMeshViz::finish();
  SoXt::finish();

  return 0;
}

#if defined(_MSC_VER)
#pragma warning( pop ) 
#endif

