#include <MbSampleMeshBuilder.h>

#include <MeshVizXLM/mapping/MoMeshViz.h>
#include <MeshVizXLM/mapping/nodes/MoMesh.h>
#include <MeshVizXLM/mapping/nodes/MoScalarSetIj.h>
#include <MeshVizXLM/mapping/nodes/MoLinearColorMapping.h>
#include <MeshVizXLM/mapping/nodes/MoLevelColorMapping.h>
#include <MeshVizXLM/mapping/nodes/MoPredefinedColorMapping.h>
#include <MeshVizXLM/mapping/nodes/MoCustomColorMapping.h>
#include <MeshVizXLM/mapping/nodes/MoMeshSurface.h>
#include <MeshVizXLM/mapping/nodes/MoMaterial.h>
#include <MeshVizXLM/mapping/nodes/MoDrawStyle.h>
#include <MeshVizXLM/mapping/nodes/MoLegend.h>

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoTranslation.h>
#include <Inventor/nodes/SoAnnoText3.h>
#include <Inventor/nodes/SoSwitch.h>

#include <Inventor/nodes/SoEventCallback.h>
#include <Inventor/nodes/SoCallback.h>
#include <Inventor/events/SoKeyboardEvent.h> 

#include <Inventor/STL/iostream>
#include <Inventor/STL/vector>
using namespace std;

#define NAMESTR "MeshVizXLM showing the enhanced coloring of polygons "

#if defined(_MSC_VER)
#pragma warning( push )
#pragma warning(disable:4250)
#endif

class myColorMapping : public MiColorMapping<double,SbColorRGBA>
{
public:
  myColorMapping(double min, double max) : m_min(min), m_max(max){}
  
  virtual SbColorRGBA getColor(double value) const
  {
    return SbColorRGBA(float((value-m_min)/(m_max-m_min)),0,0.5,1);
  }
  virtual void getRange(double& min, double& max) const 
  {
    min = m_min;
    max = m_max;
  }
  virtual size_t getTimeStamp() const {return 0;}
  double m_min;
  double m_max;

};

void
editSwitch(void *userData, SoEventCallback *eventCB)
{
  const SoEvent *ev = eventCB->getEvent();
  SoSwitch* sw = (SoSwitch*) userData;
  if (sw)
  {
    if (SO_KEY_PRESS_EVENT(ev, F1)) 
    {
      int cmap = sw->whichChild.getValue()+1;
      if (cmap >= sw->getNumChildren())
        cmap = 0;
      sw->whichChild = cmap;
    }
  }
}

void
editLinearCmap(void *userData, SoEventCallback *eventCB)
{
  const SoEvent *ev = eventCB->getEvent();
  MoLinearColorMapping* linearCM = (MoLinearColorMapping*) userData;
  if (linearCM)
  {
    if (SO_KEY_PRESS_EVENT(ev, F2)) 
    {
      linearCM->minThresholdEnable = linearCM->minThresholdEnable.getValue() == TRUE ? FALSE : TRUE;
    }

  }
}
void
editLevelCmap(void *userData, SoEventCallback *eventCB)
{
  const SoEvent *ev = eventCB->getEvent();
  MoLevelColorMapping* levelCM = (MoLevelColorMapping*) userData;
  if (levelCM)
  {
    if (SO_KEY_PRESS_EVENT(ev, F2)) 
    {
      levelCM->minThresholdEnable = levelCM->minThresholdEnable.getValue() == TRUE ? FALSE : TRUE;
    }

  }
}

//-----------------------------------------------------------------------------
int
main(int, char **)
{
  cout << "Press F1 for switching between level colormap and linear colormap " << endl;
  cout << "Press F2 for enabling min threshold (linear and level colormap only) " << endl;

  size_t numCellI = 2, numCellJ = 2;
  MbSampleMeshBuilder<MbVec3f,float> meshBuilder;
  MbSurfaceMeshCurvilinear<MbVec3f,float,MbVec3f>& mesh = meshBuilder.getSurfaceMeshCurvilinear(numCellI,numCellJ,MbVec3f(0,0,0),MbVec3f(1,0,0),MbVec3f(0,1,0));
  
  MbScalarSetIj<float>* scalar2 = new MbScalarSetIj<float>(numCellI+1,numCellJ+1);
  scalar2->set(0,0,0.0f);
  scalar2->set(0,1,1.0f);
  scalar2->set(0,2,0.0f);
  
  scalar2->set(1,0,1.0f);
  scalar2->set(1,1,0.0f);
  scalar2->set(1,2,1.0f);

  scalar2->set(2,0,0.0f);
  scalar2->set(2,1,1.0f);
  scalar2->set(2,2,0.0f);

  // Init viewer
  Widget my_window = SoXt::init(NAMESTR) ;
  if (my_window == NULL) exit(1) ;

  MoMeshViz::init();

  SoSeparator* sep = new SoSeparator;
  
  SoShapeHints * sh = new SoShapeHints;
  sh->vertexOrdering.setValue(SoShapeHints::CLOCKWISE);
  sep->addChild(sh);

  MoMesh* moMesh = new MoMesh;
  moMesh->setMesh(&mesh);
  sep->addChild(moMesh);

  MoLinearColorMapping* linearMap = new MoLinearColorMapping;
  float values[5] ;
  SbVec4f colors[4];
  float min = (float)scalar2->getMin();
  float max = (float)scalar2->getMax();
  values[0] = min;
  values[1] = (max+min)/3.0f;
  values[2] = max;
  linearMap->values.setValues(0,3,values);
  colors[0].setValue(1,0,0,1); 
  colors[1].setValue(1,1,1,1); 
  colors[2].setValue(0,0,1,1); 
  linearMap->colors.setValues(0,3,colors);
  linearMap->minThresholdColor = SbColorRGBA(0,0,0,1);
  linearMap->minThresholdEnable = FALSE;
  linearMap->minThresholdValue = (max+min)/5.0f;

  MoLevelColorMapping* levelMap = new MoLevelColorMapping;
  values[0] = min;
  values[1] = (max + min)/3.0f;
  values[2] = 2.0f*(max + min)/3.0f;
  values[3] = max;
  levelMap->values.setValues(0,4,values);
  colors[0].setValue(1,0,0,1); 
  colors[1].setValue(1,1,1,1); 
  colors[2].setValue(0,0,1,1); 
  levelMap->colors.setValues(0,3,colors);
  levelMap->minThresholdColor = SbColorRGBA(0,0,0,1);
  levelMap->minThresholdEnable = FALSE;
  levelMap->minThresholdValue = (max+min)/5.0f;

  MoPredefinedColorMapping* predefMap = new MoPredefinedColorMapping;
  predefMap->minValue = min;
  predefMap->maxValue = max;
  predefMap->predefColorMap = MoPredefinedColorMapping::PHYSICS;

  // custom color map
  MoCustomColorMapping* customCmap = new MoCustomColorMapping;
  customCmap->setColorMapping(new myColorMapping(min,max));

  SoSwitch * sw = new SoSwitch;
  sw->whichChild = 0;
  sep->addChild(sw);

  sw->addChild(linearMap);
  sw->addChild(levelMap);
  sw->addChild(predefMap);
  sw->addChild(customCmap);

  SoEventCallback *myCallbackNode = new SoEventCallback;
  myCallbackNode->addEventCallback(SoKeyboardEvent::getClassTypeId(), editSwitch, sw); 
  sep->addChild(myCallbackNode);

  SoEventCallback *myCallbackNode2 = new SoEventCallback;
  myCallbackNode2->addEventCallback(SoKeyboardEvent::getClassTypeId(), editLinearCmap, linearMap); 
  sep->addChild(myCallbackNode2);

  SoEventCallback *myCallbackNode3 = new SoEventCallback;
  myCallbackNode3->addEventCallback(SoKeyboardEvent::getClassTypeId(), editLevelCmap, levelMap); 
  sep->addChild(myCallbackNode3);

  // Scalar Value
  MoScalarSetIj *MoScalarSetIj2 = new MoScalarSetIj;
  MoScalarSetIj2->setScalarSet(scalar2);
  sep->addChild(MoScalarSetIj2);

  MoMaterial* material = new MoMaterial;
  material->enhancedColoring = TRUE;
  material->lineColor = SbColor(1,1,1);
  material->lineColoring = MoMaterial::COLOR;
  sep->addChild(material);

  MoDrawStyle* drawStyle = new MoDrawStyle;
  drawStyle->displayEdges = TRUE;
  sep->addChild(drawStyle);

  MoMeshSurface *surface = new MoMeshSurface;
  surface->colorScalarSetId = 0;
  sep->addChild(surface);

  SoFont* font = new SoFont;
  font->size = 0.2f;
  sep->addChild(font);

  SoSeparator* s1 = new SoSeparator;
  sep->addChild(s1);

  SoTranslation* translateT1 = new SoTranslation;
  translateT1->translation = SbVec3f(1,2.1f,0);
  s1->addChild(translateT1);

  SoAnnoText3 * text1 = new SoAnnoText3;
  text1->string = "Enhanced Coloring";
  text1->justification = SoAnnoText3::CENTER;
  s1->addChild(text1);

  SoSeparator* s2 = new SoSeparator;
  sep->addChild(s2);

  SoTranslation* translateT2 = new SoTranslation;
  translateT2->translation = SbVec3f(4,2.1f,0);
  s2->addChild(translateT2);

  SoAnnoText3 * text2 = new SoAnnoText3;
  text2->string = "OpenGL Coloring";
  text2->justification = SoAnnoText3::CENTER;
  s2->addChild(text2);


  SoTranslation* translate = new SoTranslation;
  translate->translation = SbVec3f(3,0,0);
  sep->addChild(translate);

  MoMaterial* material2 = new MoMaterial;
  material2->lineColor = SbColor(1,1,1);
  material2->enhancedColoring = FALSE;
  material2->lineColoring = MoMaterial::COLOR;
  sep->addChild(material2);

  MoMeshSurface *surface2 = new MoMeshSurface;
  surface2->colorScalarSetId = 0;
  sep->addChild(surface2);

  MoLegend* legendPredef = new MoLegend;
  legendPredef->title = "ColorMap";
  legendPredef->titleFontSize = 16;
  legendPredef->valuesFontSize = 15;
  legendPredef->displayValues = true;
  legendPredef->bottomLeft = SbVec2f(-0.9f,-0.9f);
  legendPredef->topRight   = SbVec2f(0.9f,-0.8f);
  legendPredef->minValue = (float)min;
  legendPredef->maxValue = (float)max;
  sep->addChild(legendPredef);

  SoXtExaminerViewer* viewer = new SoXtExaminerViewer(my_window);
  viewer->setSceneGraph(sep);
  viewer->setSize(SbVec2s(1024,768));
  viewer->show();
  viewer->viewAll();

  // dialog
  SoXt::show(my_window);
  SoXt::mainLoop();

  delete viewer;

  MoMeshViz::finish();
  SoXt::finish();

  return 0;
}

#if defined(_MSC_VER)
#pragma warning( pop ) 
#endif

