#include "DemoFenceSlice.h"

#include <Inventor/nodes/SoEventCallback.h>
#include <Inventor/nodes/SoSwitch.h>
#include <Inventor/nodes/SoMarkerSet.h>
#include <Inventor/nodes/SoLineSet.h>
#include <Inventor/events/SoKeyboardEvent.h> 
#include <MeshVizXLM/mapping/nodes/MoMeshFenceSlice.h>
#include <MeshVizXLM/mapping/nodes/MoMeshVector.h>
#include <MeshVizXLM/mapping/nodes/MoDrawStyle.h>
#include <MeshVizXLM/mapping/nodes/MoMaterial.h>

using namespace::std;

//---------------------------------------------------------------------
DemoFenceSlice::DemoFenceSlice() :
Demo("MeshVizXLM FenceSlice",VOLUME_MESH_UNSTRUCTURED,ALL_VOLUME_MESHES_NO_TETRA,true)
{
  m_move = SbVec3f(.1f,.1f,.0f);
}

//---------------------------------------------------------------------
bool DemoFenceSlice::displayInstructions() const
{
  cout << "Press x to display the slices along the x-axis" << endl;
  cout << "Press y to display the slices along the y-axis" << endl;
  cout << "Press z to display the slices along the z-axis" << endl;
  cout << "Press o/p to move the polyline" << endl;
  cout << "Press k/l to move the fence direction" << endl;
  cout << "Press e to toggle edges visibility" << endl;
  cout << "Press v to toggle vector visibility" << endl;
  return true;
}

//---------------------------------------------------------------------
void DemoFenceSlice::keyPressed(SoEventCallback *eventCB)
{
  const SoEvent *ev = eventCB->getEvent();

  if (SO_KEY_PRESS_EVENT(ev, V) )
  {
    m_vectorSwitch->whichChild = ( m_vectorSwitch->whichChild.getValue()==SO_SWITCH_ALL) ? SO_SWITCH_NONE : SO_SWITCH_ALL;
    eventCB->setHandled();
  }
  if (SO_KEY_PRESS_EVENT(ev, X) )
  {
    m_fenceslice->direction.setValue(SbVec3f(1,0,0));
    m_move = SbVec3f(.0f,.1f,.1f);
    eventCB->setHandled();
  }
  if (SO_KEY_PRESS_EVENT(ev, Y) )
  {
    m_fenceslice->direction.setValue(SbVec3f(0,1,0));
    m_move = SbVec3f(.1f,.0f,.1f);
    eventCB->setHandled();
  } 
  if (SO_KEY_PRESS_EVENT(ev, Z) )
  {
    m_fenceslice->direction.setValue(SbVec3f(0,0,1));
    m_move = SbVec3f(.1f,.1f,.0f);
    eventCB->setHandled();
  }
  if (SO_KEY_PRESS_EVENT(ev, E) )
  {
    m_fenceDS->displayEdges = !m_fenceDS->displayEdges.getValue();
    eventCB->setHandled();
  }
  if (SO_KEY_PRESS_EVENT(ev, P) )
  {
    for (int p = 0; p < m_fenceslice->polyline.getNum(); ++p)
    {
      SbVec3f point = m_fenceslice->polyline[p] + SbVec3f(.1f,.1f,.1f);
      m_fenceslice->polyline.set1Value(p,point);
    }
    eventCB->setHandled();
  }
  if (SO_KEY_PRESS_EVENT(ev, O) )
  {
    for (int p = 0; p < m_fenceslice->polyline.getNum(); ++p)
    {
      SbVec3f point = m_fenceslice->polyline[p] - SbVec3f(.1f,.1f,.1f);
      m_fenceslice->polyline.set1Value(p,point);
    }
    eventCB->setHandled();
  }
  if (SO_KEY_PRESS_EVENT(ev, L) )
  {
    m_fenceslice->direction = m_fenceslice->direction.getValue() + m_move;
    eventCB->setHandled();
  }
  if (SO_KEY_PRESS_EVENT(ev, K) )
  {
    m_fenceslice->direction = m_fenceslice->direction.getValue() - m_move;
    eventCB->setHandled();
  }
}

//---------------------------------------------------------------------
void DemoFenceSlice::getMeshAttributes(MoDrawStyle*& ds, MoMaterial*& mat, SoDrawStyle*& /*ids*/, SoPickStyle*& ps)
{
  ps = new SoPickStyle;
  ds = m_ds = new MoDrawStyle;
  mat = m_mat = new MoMaterial;
  ps->style = SoPickStyle::UNPICKABLE;
  m_ds->displayFaces = false;
  m_ds->displayEdges = true;
  m_mat->lineColor.setValue(SbColor(0,0,0));
}

//---------------------------------------------------------------------
void DemoFenceSlice::insertRepresentations(SoSeparator* sep)
{
  MoMaterial* mat = new MoMaterial;
  mat->lineColoring = MoMaterial::COLOR;
  mat->lineColor = SbColor(0,0,0);
  m_fenceDS = new MoDrawStyle;
  m_fenceslice = new MoMeshFenceSlice;
  m_fenceslice->polyline.setNum(7);
  m_fenceslice->polyline.set1Value(0,SbVec3f(5,1,2));
  m_fenceslice->polyline.set1Value(1,SbVec3f(4,3,5));
  m_fenceslice->polyline.set1Value(2,SbVec3f(1,7,4));
  m_fenceslice->polyline.set1Value(3,SbVec3f(3,9,2));
  m_fenceslice->polyline.set1Value(4,SbVec3f(5,7,3));
  m_fenceslice->polyline.set1Value(5,SbVec3f(6,12,11));
  m_fenceslice->polyline.set1Value(6,SbVec3f(10,14,16));
  m_fenceslice->direction.setValue(SbVec3f(0,0,1));

  SoVertexProperty* vertexProp = new SoVertexProperty;
  vertexProp->vertex.connectFrom(&m_fenceslice->polyline);
  SoMarkerSet* pointSet = new SoMarkerSet;
  pointSet->vertexProperty.setValue(vertexProp);
  pointSet->markerIndex = SoMarkerSet::CIRCLE_FILLED_5_5;
  SoLineSet* polyline = new SoLineSet;
  polyline->vertexProperty.setValue(vertexProp);

  sep->addChild(polyline);
  sep->addChild(pointSet);
  sep->addChild(mat);
  sep->addChild(m_fenceDS);
  sep->addChild(m_fenceslice);

  m_vectorSwitch = new SoSwitch;
  MoMesh* fenceMesh = new MoMesh;
  fenceMesh->connectFrom(m_fenceslice);
  
  sep->addChild(m_vectorSwitch);
  {
    m_vectorSwitch->addChild(fenceMesh);
    MoMeshVector* vector = new MoMeshVector;
    vector->scaleFactor = 0.1f;
    vector->thicknessFactor = 0.5f;
    m_vectorSwitch->addChild(vector);
  }
}


