#include "DemoFenceSliceSelection.h"

#include <Inventor/nodes/SoEventCallback.h>
#include <Inventor/nodes/SoSwitch.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoLineSet.h>
#include <Inventor/events/SoKeyboardEvent.h> 
#include <Inventor/events/SoMouseButtonEvent.h> 
#include <Inventor/SoPickedPoint.h>
#include <Inventor/nodes/SoDepthOffset.h>

#include <MeshVizXLM/mapping/nodes/MoMeshFenceSlice.h>
#include <MeshVizXLM/mapping/nodes/MoDrawStyle.h>
#include <MeshVizXLM/mapping/nodes/MoMaterial.h>
#include <MeshVizXLM/mapping/details/MoFaceDetail.h>
#include <MeshVizXLM/extrmesh/MeXSurfaceMeshUnstructured.h>

//---------------------------------------------------------------------
DemoFenceSliceSelection::DemoFenceSliceSelection() :
Demo("MeshVizXLM FenceSliceSelection",VOLUME_MESH_UNSTRUCTURED,ALL_VOLUME_MESHES_NO_TETRA,true)
{
  m_move = SbVec3f(.1f,.1f,.0f);
}

//---------------------------------------------------------------------
bool DemoFenceSliceSelection::displayInstructions() const
{
  cout << "Press left mouse button to add a new point to the fence polyline" << endl;
  cout << "Double click to clear the current fence slice and start a new one" << endl;
  cout << "Press k/l to move the fence direction" << endl;
  cout << "Press e to toggle edges visibility" << endl;
  return true;
}


//------------------------------------------------------------------------
// Function called each time the mouse button is pressed in the viewer window
void DemoFenceSliceSelection::mousePressed(SoEventCallback *eventCB) 
{
  bool isDoubleClick = SoMouseButtonEvent::isButtonDoubleClickEvent(eventCB->getEvent(),SoMouseButtonEvent::BUTTON1);
  if (isDoubleClick)
    // clear the existing fence slice
    m_fenceslice->polyline.setNum(0);
  else if (SoMouseButtonEvent::isButtonPressEvent(eventCB->getEvent(),SoMouseButtonEvent::BUTTON1))
  {
    const SoPickedPoint* pickedPoint = eventCB->getPickedPoint();
    if (pickedPoint != NULL) 
    {
      const SoDetail* detail = pickedPoint->getDetail();
      // check if the picked point comes from a mesh representation (a skin here)
      if (detail->isOfType(MoFaceDetail::getClassTypeId()))
      {
        SbVec3f pickedPointCoord = pickedPoint->getPoint();
        if (m_fenceslice->polyline.getNum() == 0)
        {
          //the first point of a fence has been picked: we use the normal of the first 
          //picked face on the skin as the direction of the fence.

          // get the normal of the picked face on the extracted skin.
          MoFaceDetail* faceDetail = (MoFaceDetail*) detail;
          size_t faceid = faceDetail->getFaceIndex();
          const MeXSurfaceMeshUnstructured* mexmesh = faceDetail->getMeshRepresentationDetail()->getExtractedMesh();
          const MeXSurfaceCell* surfaceCell = mexmesh->getTopology().getCell(faceid);
          m_fenceslice->direction = (SbVec3f)surfaceCell->getNormal(&mexmesh->getGeometry());
        }
        m_fenceslice->polyline.set1Value(m_fenceslice->polyline.getNum(),pickedPointCoord);
      }
    }
  }
}

//---------------------------------------------------------------------
void DemoFenceSliceSelection::keyPressed(SoEventCallback *eventCB)
{
  const SoEvent *ev = eventCB->getEvent();

  if (SO_KEY_PRESS_EVENT(ev, E) )
  {
    m_fenceDS->displayEdges = !m_fenceDS->displayEdges.getValue();
    eventCB->setHandled();
  }
  if (SO_KEY_PRESS_EVENT(ev, L) )
  {
    m_fenceslice->direction = m_fenceslice->direction.getValue() + m_move;
    eventCB->setHandled();
  }
  if (SO_KEY_PRESS_EVENT(ev, K) )
  {
    m_fenceslice->direction = m_fenceslice->direction.getValue() - m_move;
    eventCB->setHandled();
  }
}

//---------------------------------------------------------------------
void DemoFenceSliceSelection::getMeshAttributes(MoDrawStyle*& ds, MoMaterial*& mat, SoDrawStyle*& /*ids*/, SoPickStyle*& ps)
{
  ps = new SoPickStyle;
  ds = m_ds = new MoDrawStyle;
  mat = m_mat = new MoMaterial;
  ps->style = SoPickStyle::SHAPE;
  m_ds->displayFaces = true;
  m_ds->displayEdges = true;
  m_mat->faceColor = SbColor(1,1,1);
  m_mat->faceColoring = MoMaterial::COLOR;
  m_mat->lineColoring =  MoMaterial::CONTOURING;

  m_mat->transparency = 0.65f;
}



//---------------------------------------------------------------------
void DemoFenceSliceSelection::insertRepresentations(SoSeparator* sep)
{
  SoDepthOffset* fenceOffset = new SoDepthOffset;

  MoMaterial* mat = new MoMaterial;
  mat->lineColoring = MoMaterial::COLOR;
  mat->lineColor = SbColor(0,0,0);
  m_fenceDS = new MoDrawStyle;
  m_fenceslice = new MoMeshFenceSlice;
  m_fenceslice->polyline.setNum(7);
  float topZcoord = NUM_CELL_K;
  m_fenceslice->polyline.set1Value(0,SbVec3f(5,1,topZcoord));
  m_fenceslice->polyline.set1Value(1,SbVec3f(4,3,topZcoord));
  m_fenceslice->polyline.set1Value(2,SbVec3f(1,7,topZcoord));
  m_fenceslice->polyline.set1Value(3,SbVec3f(3,9,topZcoord));
  m_fenceslice->polyline.set1Value(4,SbVec3f(5,7,topZcoord));
  m_fenceslice->polyline.set1Value(5,SbVec3f(6,12,topZcoord));
  m_fenceslice->polyline.set1Value(6,SbVec3f(10,14,topZcoord));
  m_fenceslice->direction.setValue(SbVec3f(0,0,1));

  SoVertexProperty* vertexProp = new SoVertexProperty;
  vertexProp->vertex.connectFrom(&m_fenceslice->polyline);
  SoDrawStyle* polylineDS = new SoDrawStyle;
  polylineDS->lineWidth = 2;

  SoLineSet* polyline = new SoLineSet;
  polyline->vertexProperty.setValue(vertexProp);

  SoMaterial* polylineMaterial = new SoMaterial;
  polylineMaterial->diffuseColor = SbColor(1,0,0);

  sep->addChild(mat);
  sep->addChild(fenceOffset);
  sep->addChild(m_fenceDS);
  sep->addChild(m_fenceslice);

  sep->addChild(polylineDS);
  sep->addChild(polylineMaterial);
  sep->addChild(polyline);
}


