#include <MeshVizXLM/mesh/cell/MiCellFilterIjk.h>

#include <mesh/volumes/MbVolumeMeshTetrahedron.h>
#include <mesh/volumes/MbVolumeMeshRegular.h>
#include <data/MbVec3SetI.h>

#include <colormapping/MbLinearColorMapping.h>
#include <colormapping/MbLevelColorMapping.h>

#include <MeshVizXLM/mapping/MoMeshViz.h>
#include <MeshVizXLM/mapping/nodes/MoMesh.h>
#include <MeshVizXLM/mapping/nodes/MoScalarSetI.h>
#include <MeshVizXLM/mapping/nodes/MoScalarSetIjk.h>
#include <MeshVizXLM/mapping/nodes/MoVec3SetI.h>
#include <MeshVizXLM/mapping/nodes/MoVec3SetIjk.h>
#include <MeshVizXLM/mapping/nodes/MoPredefinedColorMapping.h>
#include <MeshVizXLM/mapping/nodes/MoCustomColorMapping.h>
#include <MeshVizXLM/mapping/nodes/MoMeshGridPlaneSlice.h>
#include <MeshVizXLM/mapping/nodes/MoMeshSkin.h>
#include <MeshVizXLM/mapping/nodes/MoMeshVector.h>
#include <MeshVizXLM/mapping/nodes/MoCellFilter.h>
#include <MeshVizXLM/mapping/nodes/MoDataBinding.h>
#include <MeshVizXLM/mapping/nodes/MoDrawStyle.h>
#include <MeshVizXLM/mapping/nodes/MoMaterial.h>

#include <MbSampleMeshBuilder.h>

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoSwitch.h>
#include <Inventor/nodes/SoCube.h>
#include <Inventor/manips/SoClipPlaneManip.h>
#include <Inventor/nodes/SoTranslation.h>
#include <Inventor/nodes/SoEventCallback.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/events/SoKeyboardEvent.h>

#include <Inventor/manips/SoClipPlaneManip.h>

#include "../DemoTemplate/Vec3Set.h"

#include <Inventor/STL/iostream>
#include <Inventor/STL/fstream>
#include <Inventor/STL/vector>
using namespace std;

#define NAMESTR "MeshVizXLM sample program showing how to use a logical slice"

MbLinearColorMapping<double,SbColorRGBA,float> linearColorMap;
MbLevelColorMapping<double,SbColorRGBA> levelColorMapping;

SoSwitch* m_sliceSwitch;
SoSwitch* m_skinSwitch;
SoSwitch* m_vectorSwitch;

#ifdef _MSC_VER
#pragma warning( push )
#pragma warning(disable:4250)
#endif

#define NUM_CELL_I 10
#define NUM_CELL_J 10
#define NUM_CELL_K 10

static MbSampleMeshBuilder<MbVec3d,double> meshBuilder1, meshBuilder2, meshBuilder3, meshBuilder4, meshBuilder5, meshBuilder6;
static MbVolumeMeshRegular<double,double,MbVec3d>* meshReg = &meshBuilder1.getVolumeMeshRegular(MbVec3<size_t>(NUM_CELL_I,NUM_CELL_J,NUM_CELL_K), MbVec3d(0), MbVec3d(10));
static MbVolumeMeshRectilinear<double,double,MbVec3d>* meshRecti = &meshBuilder6.getVolumeMeshRectilinear(MbVec3<size_t>(NUM_CELL_I,NUM_CELL_J,NUM_CELL_K), MbVec3d(0), MbVec3d(10));
static MbVolumeMeshCurvilinear<MbVec3d,double,MbVec3d>* meshCurv = &meshBuilder4.getVolumeMeshCurvilinear(MbVec3<size_t>(NUM_CELL_I,NUM_CELL_J,NUM_CELL_K), MbVec3d(0), MbVec3d(10));
static MbVolumeMeshTetrahedron<MbVec3d,double,MbVec3d>* meshTetra = &meshBuilder2.getMeshTetrahedron(MbVec3<size_t>(NUM_CELL_I,NUM_CELL_J,NUM_CELL_K), MbVec3d(0), MbVec3d(10));
static MbHexahedronMeshIjk<MbVec3d,double,MbVec3d>* meshHexaIjk = &meshBuilder3.getHexahedronMeshIjk(MbVec3<size_t>(NUM_CELL_I,NUM_CELL_J,NUM_CELL_K), MbVec3d(0), MbVec3d(10));


class MyCellFilter : public MiCellFilterIjk
{
public:
  virtual bool acceptCell(size_t i, size_t j, size_t /*k*/) const 
  { 
    // Compute any random function 
    if (((NUM_CELL_I/3.0f)<i && i<=(2*NUM_CELL_I/3.0f)) && ((NUM_CELL_J/3.0f)<j && j<=(2*NUM_CELL_J/3.0f))) return false;
    else return true;
  }
  virtual size_t getTimeStamp() const { return 0; }
};

void
editMesh(void *userData, SoEventCallback *eventCB)
{
  const SoEvent *ev = eventCB->getEvent();

  bool handled = false;

  MoMesh *moMesh = (MoMesh*) userData;;
  if (moMesh) {
    if (SO_KEY_PRESS_EVENT(ev, NUMBER_1))
    {
      cout << "Displaying Tetrahedon mesh" << endl;
      moMesh->setMesh(meshTetra);
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, NUMBER_2))
    {
      cout << "Displaying Regular mesh" << endl;
      moMesh->setMesh(meshReg);
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, NUMBER_3))
    {
      cout << "Displaying Rectilinear mesh" << endl;
      moMesh->setMesh(meshRecti);
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, NUMBER_4))
    {
      cout << "Displaying Curvilinear mesh" << endl;
      moMesh->setMesh(meshCurv);
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, NUMBER_5))
    {
      cout << "Displaying Hexahedron meshIjk" << endl;
      moMesh->setMesh(meshHexaIjk);
      handled = true;
    }
  }

  if (handled) 
    eventCB->setHandled();
}

void
editGridPlaneSlice(void *userData, SoEventCallback *eventCB)
{
  bool handled = false;
  const SoEvent *ev = eventCB->getEvent();

  MoMeshGridPlaneSlice *slice = (MoMeshGridPlaneSlice*) (userData);
  if (slice) {
    if (SO_KEY_PRESS_EVENT(ev, I) )
    {
      slice->step.setValue(slice->step.getValue()/(float)1.5);
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, D) )
    {
      slice->step.setValue(slice->step.getValue()*(float)1.5);
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, M) )
    {
      m_skinSwitch->whichChild = ( m_skinSwitch->whichChild.getValue()==SO_SWITCH_ALL) ? SO_SWITCH_NONE : SO_SWITCH_ALL;
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, S) )
    {
      m_sliceSwitch->whichChild = ( m_sliceSwitch->whichChild.getValue()==SO_SWITCH_ALL) ? SO_SWITCH_NONE : SO_SWITCH_ALL;
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, V) )
    {
      m_vectorSwitch->whichChild = ( m_vectorSwitch->whichChild.getValue()==SO_SWITCH_ALL) ? SO_SWITCH_NONE : SO_SWITCH_ALL;
      handled = true;
    }
  }

  if (handled) 
    eventCB->setHandled();
}


//-----------------------------------------------------------------------------
int
main(int, char **)
{
  cout << "Press 1 for Unstructured mesh" << endl;
  cout << "Press 2 for Regular mesh" << endl;
  cout << "Press 3 for Rectilinear mesh" << endl;
  cout << "Press 4 for Curvilinear mesh" << endl;
  cout << "Press 5 for HexahedronIjk mesh" << endl;
  cout << "Press i or d to increase or decrease grid density" << endl;
  cout << "Press m to toggle mesh visibility" << endl;
  cout << "Press s to toggle slice visibility" << endl;
  cout << "Press v to toggle vector visibility (only when slice is visible)" << endl;

  // Init viewer
  Widget my_window = SoXt::init(NAMESTR) ;
  if (my_window == NULL) exit(1) ;

  MoMeshViz::init();

  SoSeparator* sep = new SoSeparator;

  cout << "Displaying Regular mesh" << endl;
  MoMesh* moMesh = new MoMesh;
  moMesh->setMesh(meshReg);
  sep->addChild(moMesh);

  MoDataBinding* dataBinding = new MoDataBinding;
  dataBinding->dataBinding = MoDataBinding::PER_NODE;
  sep->addChild(dataBinding);

  MoScalarSetI *moScalarSetI = new MoScalarSetI;
  moScalarSetI->setScalarSet(meshHexaIjk->getScalarSet("$Sphere"));
  sep->addChild(moScalarSetI);

  MoScalarSetIjk *moScalarSetIjk = new MoScalarSetIjk;
  moScalarSetIjk->setScalarSet(meshReg->getScalarSetIjk("$Sphere"));
  sep->addChild(moScalarSetIjk);

  MoCellFilter* cellFilter = new MoCellFilter;
  cellFilter->setCellFilter(new MyCellFilter);
  sep->addChild(cellFilter);
 
  MoPredefinedColorMapping* colMap = new MoPredefinedColorMapping;
  colMap->minValue = (float)meshReg->getScalarSetIjk("$Sphere")->getMin();
  colMap->maxValue = (float)meshReg->getScalarSetIjk("$Sphere")->getMax();
  colMap->predefColorMap = MoPredefinedColorMapping::STANDARD;
  sep->addChild(colMap);

  SoSeparator* sliceSep = new SoSeparator;
  sep->addChild(sliceSep);

  m_sliceSwitch = new SoSwitch;
  sliceSep->addChild(m_sliceSwitch);
  m_sliceSwitch->whichChild = SO_SWITCH_ALL;

  SoMaterial* red = new SoMaterial;
  m_sliceSwitch->addChild(red);
  red->diffuseColor = SbColor(1,0,0);

  // Grid plane slice
  MbVec3d max = meshReg->getGeometry().getMax();
  MbVec3d min = meshReg->getGeometry().getMin();
  MbVec3d center = ( max + min )/2.0f;

  // Manipulator to move the plane slice plane (as a clip plane)
  SoClipPlaneManip *manip = new SoClipPlaneManip;
  manip->plane.setValue(SbPlane(SbVec3f(1,0,1),5.0f));
  // Turn off clip plane visibility to avoid flickering of plane slice faces.
  manip->on.setValue(FALSE); 
  manip->draggerPosition.setValue((SbVec3f((float)center[0],(float)center[1],(float)center[2])));
  m_sliceSwitch->addChild(manip);

  MoMeshGridPlaneSlice *gridPlaneSlice = new MoMeshGridPlaneSlice;
  m_sliceSwitch->addChild(gridPlaneSlice);
  gridPlaneSlice->step = .5;
  gridPlaneSlice->plane.setValue(SbPlane(SbVec3f(0,0,1),5.0f));
  gridPlaneSlice->plane.connectFrom(&manip->plane);
  gridPlaneSlice->colorScalarSetId = 0;
  gridPlaneSlice->parallel = TRUE;

  // Transparent Mesh Skin
  m_skinSwitch = new SoSwitch;
  sep->addChild(m_skinSwitch);
  m_skinSwitch->whichChild = SO_SWITCH_ALL;

  SoDrawStyle* style = new SoDrawStyle;
  style->style.setValue(SoDrawStyle::LINES);
  m_skinSwitch->addChild(style);
  SoPickStyle* pickStyle = new SoPickStyle;
  pickStyle->style.setValue(SoPickStyle::UNPICKABLE);
  m_skinSwitch->addChild(pickStyle);

  MoMeshSkin *skin = new MoMeshSkin;
  skin->colorScalarSetId = 0;
  m_skinSwitch->addChild(skin);

  // This mesh is used to connect the grid generated mesh as input of the vectors
  MoMesh* gridMesh = new MoMesh;
  gridMesh->connectFrom(gridPlaneSlice);
  m_sliceSwitch->addChild(gridMesh);
  
  Vec3Set myVec3Set(MbVec3<size_t>((size_t)NUM_CELL_I,(size_t)NUM_CELL_J,(size_t)NUM_CELL_K),MiDataSet::PER_NODE);
  // Vector filed
  MoVec3SetI *moVec3SetI = new MoVec3SetI;
  moVec3SetI->setVec3Set(&myVec3Set);
  m_sliceSwitch->addChild(moVec3SetI);
  MoVec3SetIjk *moVec3SetIjk = new MoVec3SetIjk;
  moVec3SetIjk->setVec3Set(&myVec3Set);
  m_sliceSwitch->addChild(moVec3SetIjk);

  // Display vector on grid
  m_vectorSwitch = new SoSwitch;
  m_sliceSwitch->addChild(m_vectorSwitch);
  MoMeshVector *vector = new MoMeshVector;
  vector->thicknessFactor = 0.5f;
  m_vectorSwitch->addChild(vector);

  SoEventCallback *myCallbackNode = new SoEventCallback;
  myCallbackNode->addEventCallback(SoKeyboardEvent::getClassTypeId(), editGridPlaneSlice, gridPlaneSlice); 
  sep->addChild(myCallbackNode);

  SoEventCallback *myCallbackNode2 = new SoEventCallback;
  myCallbackNode2->addEventCallback(SoKeyboardEvent::getClassTypeId(), editMesh, moMesh); 
  sep->addChild(myCallbackNode2);

  SoXtExaminerViewer* viewer = new SoXtExaminerViewer(my_window);
  viewer->setSceneGraph(sep);
  viewer->setSize(SbVec2s(1024,768));
  viewer->show();
  viewer->viewAll();

  // dialog
  SoXt::show(my_window);
  SoXt::mainLoop();

  delete viewer;

  MoMeshViz::finish();
  SoXt::finish();

  return 0;
}

#ifdef _MSC_VER
#pragma warning( pop ) 
#endif

