#include <MeshVizXLM/mesh/cell/MiCellFilterIjk.h>

#include <mesh/volumes/MbVolumeMeshTetrahedron.h>
#include <mesh/volumes/MbVolumeMeshRegular.h>
#include <data/MbVec3SetI.h>

#include <colormapping/MbLinearColorMapping.h>
#include <colormapping/MbLevelColorMapping.h>

#include <MeshVizXLM/mapping/MoMeshViz.h>
#include <MeshVizXLM/mapping/nodes/MoMesh.h>
#include <MeshVizXLM/mapping/nodes/MoScalarSetIjk.h>
#include <MeshVizXLM/mapping/nodes/MoScalarSetI.h>
#include <MeshVizXLM/mapping/nodes/MoVec3SetI.h>
#include <MeshVizXLM/mapping/nodes/MoVec3SetIjk.h>
#include <MeshVizXLM/mapping/nodes/MoPredefinedColorMapping.h>
#include <MeshVizXLM/mapping/nodes/MoCustomColorMapping.h>
#include <MeshVizXLM/mapping/nodes/MoMeshInterpolatedLogicalSlice.h>
#include <MeshVizXLM/mapping/nodes/MoMeshSkin.h>
#include <MeshVizXLM/mapping/nodes/MoMeshVector.h>
#include <MeshVizXLM/mapping/nodes/MoCellFilter.h>
#include <MeshVizXLM/mapping/nodes/MoDataBinding.h>
#include <MeshVizXLM/mapping/nodes/MoDrawStyle.h>

#include <MbSampleMeshBuilder.h>

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoSwitch.h>
#include <Inventor/nodes/SoCube.h>
#include <Inventor/nodes/SoTranslation.h>
#include <Inventor/nodes/SoEventCallback.h>
#include <Inventor/events/SoKeyboardEvent.h>  
#include <Inventor/manips/SoClipPlaneManip.h>

#include "../DemoTemplate/Vec3Set.h"

#include <Inventor/STL/iostream>
#include <Inventor/STL/fstream>
#include <Inventor/STL/vector>
using namespace std;

#define NAMESTR "MeshVizXLM sample program showing how to use an interpolated logical slice"

MbLinearColorMapping<double,SbColorRGBA,float> linearColorMap;
MbLevelColorMapping<double,SbColorRGBA> levelColorMapping;

SoSwitch* m_vectorSwitch;

#if defined(_MSC_VER)
#pragma warning( push )
#pragma warning(disable:4250)
#endif

#define NUM_CELL_I 10
#define NUM_CELL_J 10
#define NUM_CELL_K 10

static MbSampleMeshBuilder<MbVec3d,double> meshBuilder1, meshBuilder2, meshBuilder3;
static MbVolumeMeshRegular<double,double,MbVec3d>* meshIjk = &meshBuilder1.getVolumeMeshRegular(MbVec3<size_t>(NUM_CELL_I,NUM_CELL_J,NUM_CELL_K), MbVec3d(0), MbVec3d(100));
static MbHexahedronMeshIjk<MbVec3d,double,MbVec3d>* meshHexaIjk = &meshBuilder3.getHexahedronMeshIjk(MbVec3<size_t>(NUM_CELL_I,NUM_CELL_J,NUM_CELL_K), MbVec3d(0), MbVec3d(100));


float m_step = 0.2f;

class MyCellFilter : public MiCellFilterIjk
{
public:
  virtual bool acceptCell(size_t i, size_t j, size_t /*k*/) const 
  { 
    // Compute any random function 
    if (((NUM_CELL_I/3.0f)<i && i<=(2*NUM_CELL_I/3.0f)) && ((NUM_CELL_J/3.0f)<j && j<=(2*NUM_CELL_J/3.0f))) return false;
    else return true;
  }
  virtual size_t getTimeStamp() const { return 0; }
};

void
editLogicalSlice(void *userData, SoEventCallback *eventCB)
{
  bool handled = false;
  const SoEvent *ev = eventCB->getEvent();

  MoMeshInterpolatedLogicalSlice *slice = (MoMeshInterpolatedLogicalSlice*) (userData);
  if (slice) {
    if (SO_KEY_PRESS_EVENT(ev, U)) 
    {
      slice->sliceValue.setValue(slice->sliceValue.getValue()+m_step);
      handled = true;

    } 
    else if (SO_KEY_PRESS_EVENT(ev, D) )
    {
      slice->sliceValue.setValue(slice->sliceValue.getValue()-m_step);
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, I) )
    {
      slice->sliceAxis = MiMesh::DIMENSION_I;
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, J) )
    {
      slice->sliceAxis = MiMesh::DIMENSION_J;
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, K) )
    {
      slice->sliceAxis = MiMesh::DIMENSION_K;
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, V) )
    {
      m_vectorSwitch->whichChild = ( m_vectorSwitch->whichChild.getValue()==SO_SWITCH_ALL) ? SO_SWITCH_NONE : SO_SWITCH_ALL;
      handled = true;
    }
  }


  if (handled) 
    eventCB->setHandled();
}

void
editMesh(void *userData, SoEventCallback *eventCB)
{
  const SoEvent *ev = eventCB->getEvent();

  bool handled = false;

  MoMesh *moMesh = (MoMesh*) userData;;
  if (moMesh) {
    if (SO_KEY_PRESS_EVENT(ev, NUMBER_1))
    {
      cout << "Displaying Regular mesh" << endl;
      moMesh->setMesh(meshIjk);
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, NUMBER_2))
    {
      cout << "Displaying Hexahedron meshIjk" << endl;
      moMesh->setMesh(meshHexaIjk);
      handled = true;
    }
  }

  if (handled) 
    eventCB->setHandled();
}


//-----------------------------------------------------------------------------
int
main(int, char **)
{
  cout << "Press d or u to decrease/increase slice index" << endl;
  cout << "Press 1 for Regular mesh" << endl;
  cout << "Press 2 for HexahedronIjk mesh" << endl;
  cout << "Press i to display slice along the i-axis" << endl;
  cout << "Press j to display slice along the j-axis" << endl;
  cout << "Press k to display slice along the k-axis" << endl;
  cout << "Press v to toggle vector visibility" << endl;

  // Init viewer
  Widget my_window = SoXt::init(NAMESTR) ;
  if (my_window == NULL) exit(1) ;

  MoMeshViz::init();

  SoSeparator* sep = new SoSeparator;
  
  SoShapeHints * sh = new SoShapeHints;
  sh->vertexOrdering.setValue(SoShapeHints::CLOCKWISE);
  sep->addChild(sh);

  MoMesh* moMesh = new MoMesh;
  moMesh->setMesh(meshIjk);
  sep->addChild(moMesh);

  MoDataBinding* dataBinding = new MoDataBinding;
  dataBinding->dataBinding = MoDataBinding::PER_NODE;
  sep->addChild(dataBinding);

  MoScalarSetIjk *moScalarSetIjk = new MoScalarSetIjk;
  moScalarSetIjk->setScalarSet(meshIjk->getScalarSetIjk("$Sphere"));
  sep->addChild(moScalarSetIjk);

  MoScalarSetI *moScalarSetI = new MoScalarSetI;
  moScalarSetI->setScalarSet(meshHexaIjk->getScalarSet("$Sphere"));
  sep->addChild(moScalarSetI);

  MoCellFilter* cellFilter = new MoCellFilter;
  cellFilter->setCellFilter(new MyCellFilter);
  sep->addChild(cellFilter);
  MoPredefinedColorMapping* colMap = new MoPredefinedColorMapping;
  colMap->minValue = (float)meshIjk->getScalarSetIjk("$Sphere")->getMin();
  colMap->maxValue = (float)meshIjk->getScalarSetIjk("$Sphere")->getMax();
  colMap->predefColorMap = MoPredefinedColorMapping::STANDARD;
  sep->addChild(colMap);

  // Cross Section
  MoMeshInterpolatedLogicalSlice *logicalSlice = new MoMeshInterpolatedLogicalSlice;
  sep->addChild(logicalSlice);
  logicalSlice->sliceValue = 0.8f;
  logicalSlice->sliceAxis = MiMesh::DIMENSION_K;
  logicalSlice->colorScalarSetId = 0;

  // Transparent Mesh Skin
  MoDrawStyle* style = new MoDrawStyle;
  style->displayFaces = false;
  style->displayEdges = true;
  sep->addChild(style);
  SoPickStyle* pickStyle = new SoPickStyle;
  pickStyle->style.setValue(SoPickStyle::UNPICKABLE);
  sep->addChild(pickStyle);

  MoMeshSkin *skin = new MoMeshSkin;
  skin->colorScalarSetId = 0;
  sep->addChild(skin);

// This mesh is used to connect the logical slice generated mesh as input of the vectors
  MoMesh* sliceMesh = new MoMesh;
  sliceMesh->connectFrom(logicalSlice);
  sep->addChild(sliceMesh);
  
  Vec3Set myVec3Set(MbVec3<size_t>((size_t)NUM_CELL_I,(size_t)NUM_CELL_J,(size_t)NUM_CELL_K),MiDataSet::PER_NODE);
  // Vector filed
  MoVec3SetI *moVec3SetI = new MoVec3SetI;
  moVec3SetI->setVec3Set(&myVec3Set);
  sep->addChild(moVec3SetI);
  MoVec3SetIjk *moVec3SetIjk = new MoVec3SetIjk;
  moVec3SetIjk->setVec3Set(&myVec3Set);
  sep->addChild(moVec3SetIjk);

  // Display vector on grid
  m_vectorSwitch = new SoSwitch;
  sep->addChild(m_vectorSwitch);
  MoMeshVector *vector = new MoMeshVector;
  vector->scaleFactor = 10.0f;
  vector->thicknessFactor = 0.5f;
  m_vectorSwitch->addChild(vector);

  SoEventCallback *myCallbackNode = new SoEventCallback;
  myCallbackNode->addEventCallback(SoKeyboardEvent::getClassTypeId(), editLogicalSlice, logicalSlice); 
  sep->addChild(myCallbackNode);

  SoEventCallback *myCallbackNode2 = new SoEventCallback;
  myCallbackNode2->addEventCallback(SoKeyboardEvent::getClassTypeId(), editMesh, moMesh); 
  sep->addChild(myCallbackNode2);

  SoXtExaminerViewer* viewer = new SoXtExaminerViewer(my_window);
  viewer->setSceneGraph(sep);
  viewer->setSize(SbVec2s(1024,768));
  viewer->show();
  viewer->viewAll();

  // dialog
  SoXt::show(my_window);
  SoXt::mainLoop();

  delete viewer;

  MoMeshViz::finish();
  SoXt::finish();

  return 0;
}

#if defined(_MSC_VER)
#pragma warning( pop ) 
#endif

