#include <MbSampleMeshBuilder.h>

#include <colormapping/MbLinearColorMapping.h>
#include <colormapping/MbLevelColorMapping.h>

#include <MeshVizXLM/mapping/MoMeshViz.h>
#include <MeshVizXLM/mapping/nodes/MoMesh.h>
#include <MeshVizXLM/mapping/nodes/MoScalarSetI.h>
#include <MeshVizXLM/mapping/nodes/MoScalarSetIj.h>
#include <MeshVizXLM/mapping/nodes/MoVec3SetI.h>
#include <MeshVizXLM/mapping/nodes/MoPredefinedColorMapping.h>
#include <MeshVizXLM/mapping/nodes/MoCustomColorMapping.h>
#include <MeshVizXLM/mapping/nodes/MoMeshAnnotatedIsoline.h>
#include <MeshVizXLM/mapping/nodes/MoMeshVector.h>
#include <MeshVizXLM/mapping/nodes/MoMeshSurface.h>
#include <MeshVizXLM/mapping/nodes/MoDrawStyle.h>
#include <MeshVizXLM/mapping/nodes/MoMaterial.h>

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoCube.h>
#include <Inventor/nodes/SoSwitch.h>
#include <Inventor/nodes/SoTranslation.h>
#include <Inventor/nodes/SoEventCallback.h>
#include <Inventor/nodes/SoCallback.h>
#include <Inventor/events/SoKeyboardEvent.h>
#include <Inventor/nodes/SoText2.h>

#include <Inventor/STL/iostream>
#include <Inventor/STL/fstream>
#include <Inventor/STL/vector>
using namespace std;

#include "../DemoTemplate/Vec3Set.h"

#define NAMESTR "MeshVizXLM program showing how to create annotated isolines"
#define NUM_CELL_I  50
#define NUM_CELL_J  50
#define STEP       3

MbLinearColorMapping<double,SbColorRGBA,float> linearColorMap;
MbLevelColorMapping<double,SbColorRGBA> levelColorMapping;

SoSwitch* m_vectorSwitch;
float s_min,s_max;
void computeIsovalues(std::vector<float>& isovalues)
{
  size_t numIsoValues = isovalues.size();
  float delta = (s_max - s_min)/numIsoValues;
  for (size_t i=0; i< numIsoValues; i++)
    isovalues[i] = i*delta + s_min;
}

#if defined(_MSC_VER)
#pragma warning( push )
#pragma warning(disable:4250)
#endif

class AltitudeFctor : public MbScalarFunctor<float>
{
  float operator()(float /*x*/, float /*y*/, float z) const
  {
    return z;
  }
};

void
editScalarSet(void *userData, SoEventCallback *eventCB)
{
  const SoEvent *ev = eventCB->getEvent();

  bool handled = false;

  MoMeshAnnotatedIsoline *isoline = (MoMeshAnnotatedIsoline*) userData;
  if (isoline) {
    if (SO_KEY_PRESS_EVENT(ev, V) )
    {
      m_vectorSwitch->whichChild = ( m_vectorSwitch->whichChild.getValue()==SO_SWITCH_ALL) ? SO_SWITCH_NONE : SO_SWITCH_ALL;
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, F1) )
    {
      isoline->isVisible = ( isoline->isVisible.getValue()==TRUE) ? FALSE : TRUE;
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, U) )
    {
      isoline->firstMajor.setValue(isoline->firstMajor.getValue()+1);
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, D) )
    {
      int val = isoline->firstMajor.getValue()-1;
      if (val >= 0)
        isoline->firstMajor.setValue(val);
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, M) )
    {
      isoline->majorPeriod.setValue(isoline->majorPeriod.getValue()+1);
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, L) )
    {
      int val = isoline->majorPeriod.getValue()-1;
      if (val >= 0)
        isoline->majorPeriod.setValue(isoline->majorPeriod.getValue()-1);
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, P) )
    {
      int numIsoValues = isoline->isovalues.getNum() + 1;
      std::vector<float> isovalues(numIsoValues);
      computeIsovalues(isovalues);
      isoline->isovalues.setValues(0,numIsoValues,&isovalues[0]);
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, O) )
    {
      int numIsoValues = isoline->isovalues.getNum() - 1;
      if (numIsoValues < 0) numIsoValues=0;
      isoline->isovalues.setNum(numIsoValues);
      if(numIsoValues)
      {
        std::vector<float> isovalues(numIsoValues);
        computeIsovalues(isovalues);
        isoline->isovalues.setValues(0,numIsoValues,&isovalues[0]);
      }
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, F2) )
    {
      int val = isoline->path.getValue()+1;
      if (val >= 3)
        val = 0;
      isoline->path.setValue(val);
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, F3) )
    {
      isoline->isText2D = ( isoline->isText2D.getValue()==TRUE) ? FALSE : TRUE;
      if (isoline->isText2D.getValue() == TRUE)
        isoline->fontSize = 10;
      else
        isoline->fontSize = 0.01f;

      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, F4) )
    {
      float val = isoline->gap.getValue()+0.01f;
      isoline->gap.setValue(val);
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, F5) )
    {
      float val = isoline->gap.getValue()-0.01f;
      isoline->gap.setValue(val);
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, F6) )
    {
      isoline->isBackground = ( isoline->isBackground.getValue()==TRUE) ? FALSE : TRUE;
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, F7) )
    {
      SbVec3f vectors[]={SbVec3f(1,0,0),SbVec3f(0,1,0),SbVec3f(0,0,1),SbVec3f(-1,0,0),SbVec3f(0,-1,0),SbVec3f(0,0,-1)};
      static int n = 0;
      isoline->upVector = vectors[n];
      cout << "UpVector: " << vectors[n] << endl;
      n++;
      if (n==6) n=0;
      handled = true;
    }

  }

  if (handled) 
    eventCB->setHandled();
}


//-----------------------------------------------------------------------------
int
main(int, char **)
{
  cout << "Press F1 to toggle isoline annotation visibility" << endl;
  cout << "Press F2 to cycle isoline annotation path" << endl;
  cout << "Press F3 to display 2D or 3D text" << endl;
  cout << "Press F4 to increase gap between 2 annotations" << endl;
  cout << "Press F5 to decrease gap between 2 annotations" << endl;
  cout << "Press F6 to toggle annotation background" << endl;
  cout << "Press F7 to switch annotation up vector between X,Y and Z" << endl;
  cout << "Press p to increase the number of isovalues" << endl;
  cout << "Press o to decrease the number of isovalues" << endl;
  cout << "Press u to increase firstMajor" << endl;
  cout << "Press d to decrease firstMajor" << endl;
  cout << "Press m to increase majorPeriod" << endl;
  cout << "Press l to decrease majorPeriod" << endl;
  cout << "Press v to toggle vector visibility" << endl;

  // Init viewer
  Widget my_window = SoXt::init(NAMESTR) ;
  if (my_window == NULL) exit(1) ;

  MoMeshViz::init();

  SoText2* t = new SoText2;
  t->ref();

  SoSeparator* sep = new SoSeparator;
 
  MbSampleMeshBuilder<MbVec3f,float> builder;
  AltitudeFctor altitudeFctor;
  builder.addScalarFctor(&altitudeFctor,"Altitude");

  std::vector<MbVec3f> coords;
  coords.resize((NUM_CELL_I+1)*(NUM_CELL_J+1));

  int n=0;
  for(size_t j=0; j<NUM_CELL_J+1;j++){
    for(size_t i=0; i<NUM_CELL_I+1;i++,n++){
      coords[n][0] = float(i);
      float x = STEP*i/10.0f;
      coords[n][1] = float(j);
      float y = STEP*j/10.0f;
      if ((i-j)<NUM_CELL_I)
        coords[n][2] = x*sin(y)/3;
      else 
        coords[n][2] = cos(x)*sin(y);
    }
  }

  MbSurfaceMeshQuadrangle<MbVec3f,float,MbVec3f>& mesh = builder.getSurfaceMeshQuadrangle(NUM_CELL_I,NUM_CELL_J,coords);
  
  MoMesh* moMesh = new MoMesh;
  moMesh->setMesh(&mesh);
  sep->addChild(moMesh);

  // Define color map
  MoPredefinedColorMapping* colMap = new MoPredefinedColorMapping;
  // Adjust range to scalar set Sphere
  colMap->minValue = s_min =(float)mesh.getScalarSet("Altitude")->getMin();
  colMap->maxValue = s_max = (float)mesh.getScalarSet("Altitude")->getMax();
  colMap->predefColorMap = MoPredefinedColorMapping::STANDARD;
  sep->addChild(colMap);

  // First Scalar Value
  MoScalarSetI *MoScalarSetI1 = new MoScalarSetI;
  MoScalarSetI1->setScalarSet(mesh.getScalarSet("Altitude"));
  sep->addChild(MoScalarSetI1);

  MoDrawStyle* ds = new MoDrawStyle;
  ds->displayFaces = FALSE;
  ds->displayEdges = TRUE;
  sep->addChild(ds);

  MoMaterial* mat1 = new MoMaterial;
  mat1->lineColoring = MoMaterial::COLOR;
  mat1->lineColor = SbColor(0.2f,0.2f,0.2f);
  sep->addChild(mat1);
  
  MoMeshSurface* meshSurface = new MoMeshSurface;
  meshSurface->colorScalarSetId = -1;
  sep->addChild(meshSurface);

  MoMaterial* mat = new MoMaterial;
  mat->lineColoring = MoMaterial::CONTOURING;
  sep->addChild(mat);

  // Isoline
  MoMeshAnnotatedIsoline *isoline = new MoMeshAnnotatedIsoline;
  sep->addChild(isoline);
  int numIsoValues=10;
  std::vector<float> isovalues(numIsoValues);
  computeIsovalues(isovalues);

  isoline->gap = 0.05f;
  isoline->fontSize = 0.01f;
  isoline->isBackground = TRUE;
  isoline->isovalues.setValues(0,numIsoValues,&isovalues[0]);
  // Use Scalar set 0 to color the isoline
  isoline->isoScalarSetId = 0;
  // Use Scalar set 0 to color the isoline
  isoline->colorScalarSetId = 0;

  // This mesh is used to connect the isolines generated mesh as input of the vectors
  MoMesh* lineMesh = new MoMesh;
  lineMesh->connectFrom(isoline);
  sep->addChild(lineMesh);

  Vec3Set myVec3Set(MbVec3<size_t>((size_t)NUM_CELL_I,(size_t)NUM_CELL_J,(size_t)0),MiDataSet::PER_NODE);
  // Vector filed
  MoVec3SetI *moVec3Set = new MoVec3SetI;
  moVec3Set->setVec3Set(&myVec3Set);
  sep->addChild(moVec3Set);

  // Display vector on isolines
  m_vectorSwitch = new SoSwitch;
  sep->addChild(m_vectorSwitch);
  MoMeshVector *vector = new MoMeshVector;
  vector->colorScalarSetId = 0;
  vector->thicknessFactor = 0.3f;
  m_vectorSwitch->addChild(vector);

  SoEventCallback *myCallbackNode = new SoEventCallback;
  myCallbackNode->addEventCallback(SoKeyboardEvent::getClassTypeId(), editScalarSet, isoline); 
  sep->addChild(myCallbackNode);


  SoXtExaminerViewer* viewer = new SoXtExaminerViewer(my_window);
  viewer->setSceneGraph(sep);
  viewer->setSize(SbVec2s(1024,768));
  viewer->show();
  viewer->viewAll();

  // dialog
  SoXt::show(my_window);
  SoXt::mainLoop();

  delete viewer;

  MoMeshViz::finish();
  SoXt::finish();

  return 0;
}

#if defined(_MSC_VER)
#pragma warning( pop ) 
#endif

