#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoCube.h>
#include <Inventor/nodes/SoTranslation.h>
#include <Inventor/nodes/SoEventCallback.h>
#include <Inventor/nodes/SoCallback.h>
#include <Inventor/events/SoKeyboardEvent.h> 

#include <MbSampleMeshBuilder.h>

#include <colormapping/MbLinearColorMapping.h>
#include <colormapping/MbLevelColorMapping.h>

#include <MeshVizXLM/mapping/MoMeshViz.h>
#include <MeshVizXLM/mapping/nodes/MoMesh.h>
#include <MeshVizXLM/mapping/nodes/MoScalarSetI.h>
#include <MeshVizXLM/mapping/nodes/MoScalarSetIjk.h>
#include <MeshVizXLM/mapping/nodes/MoVec3SetIjk.h>
#include <MeshVizXLM/mapping/nodes/MoPredefinedColorMapping.h>
#include <MeshVizXLM/mapping/nodes/MoCustomColorMapping.h>
#include <MeshVizXLM/mapping/nodes/MoMeshIsosurface.h>
#include <MeshVizXLM/mapping/nodes/MoMeshLogicalSlice.h>
#include <MeshVizXLM/mapping/nodes/MoMeshInterpolatedLogicalSlice.h>
#include <MeshVizXLM/mapping/nodes/MoMeshPlaneSlice.h>
#include <MeshVizXLM/mapping/nodes/MoMeshIsoline.h>
#include <MeshVizXLM/mapping/nodes/MoMeshSkin.h>
#include <MeshVizXLM/mapping/nodes/MoMeshVector.h>

#include <Inventor/manips/SoClipPlaneManip.h>
#include <Inventor/nodes/SoSwitch.h>

#include "../DemoTemplate/Vec3Set.h"

#include <Inventor/STL/iostream>
#include <Inventor/STL/fstream>
#include <Inventor/STL/vector>
using namespace std;

#define NAMESTR "MeshVizXLM Isoline on Isosurface"

MbLinearColorMapping<double,SbColorRGBA,float> linearColorMap;
MbLevelColorMapping<double,SbColorRGBA> levelColorMapping;

#ifdef _MSC_VER
#pragma warning( push )
#pragma warning(disable:4250)
#endif

#define NUMI 10
#define NUMJ 10
#define NUMK 10
#define NUMCELL (NUMI*NUMJ*NUMK)
#define NUMNODE ((NUMI+1)*(NUMJ+1)*(NUMK+1))

SoSwitch* m_vectorSwitch;

static float m_incr = 0.1f;

float s_min[2],s_max[2];
void computeIsovalues(std::vector<float>& isovalues, float min, float max)
{
  size_t numIsoValues = isovalues.size();
  float delta = (max - min)/numIsoValues;
  for (size_t i=0; i< numIsoValues; i++)
    isovalues[i] = i*delta + min;
}
 
void
editSwitch(void* /*userData*/, SoEventCallback *eventCB)
{
  bool handled = false;
  const SoEvent *ev = eventCB->getEvent();

  if (SO_KEY_PRESS_EVENT(ev, V) )
    {
      m_vectorSwitch->whichChild = ( m_vectorSwitch->whichChild.getValue()==SO_SWITCH_ALL) ? SO_SWITCH_NONE : SO_SWITCH_ALL;
      handled = true;
    }

  if (handled)
    eventCB->setHandled();
}

void
editIsosurface(void *userData, SoEventCallback *eventCB)
{
  bool handled = false;
  const SoEvent *ev = eventCB->getEvent();

  MoMeshIsosurface *isosurface = (MoMeshIsosurface*) (userData);
  if (isosurface) {
    if (SO_KEY_PRESS_EVENT(ev, U)) 
    {
      isosurface->isovalue.setValue(isosurface->isovalue.getValue()+m_incr);
      handled = true;

    } 
    else if (SO_KEY_PRESS_EVENT(ev, D) )
    {
      isosurface->isovalue.setValue(isosurface->isovalue.getValue()-m_incr);
      handled = true;
    }
  }


  if (handled) 
    eventCB->setHandled();
}

void
editIsolines(void *userData, SoEventCallback *eventCB)
{
  bool handled = false;
  const SoEvent *ev = eventCB->getEvent();

  SoGroup *isolines = (SoGroup*) (userData);
  if (isolines) 
  {
      for ( int i = 0; i < isolines->getNumChildren(); ++i)
      {
        MoMeshIsoline* isoline = dynamic_cast<MoMeshIsoline*> (isolines->getChild(i));
        if (isoline)
        {
          int num = isoline->isovalues.getNum();
          int n = isoline->isoScalarSetId.getValue()-1;
          if (SO_KEY_PRESS_EVENT(ev, P)) 
          {
            std::vector<float> isovalues(++num);
            computeIsovalues(isovalues,s_min[n],s_max[n]);
            isoline->isovalues.setValues(0,num,&isovalues[0]);
            handled = true;
          }
          else if (SO_KEY_PRESS_EVENT(ev, M) )
          {
            num = (num == 0) ? 0 : num-1;
            isoline->isovalues.setNum(num);
            if (num)
            {
              std::vector<float> isovalues(num);
              computeIsovalues(isovalues,s_min[n],s_max[n]);
              isoline->isovalues.setValues(0,num,&isovalues[0]);
              handled = true;
            }
          }
        }
      }
  }


  if (handled) 
    eventCB->setHandled();
}

//-----------------------------------------------------------------------------
int
main(int, char **)
{

  cout << "Press d/u to decrease/increase the isovalue" << endl;
  cout << "Press p/m to increase/decrease the number of isovalues" << endl;

  MbSampleMeshBuilder<MbVec3d,double> meshBuilder;
  MbVolumeMeshRegular<double,double,MbVec3d>* mesh = &meshBuilder.getVolumeMeshRegular(MbVec3<size_t>(NUMI,NUMJ,NUMK),MbVec3d(0),MbVec3d(1.0));

  // Init viewer
  Widget my_window = SoXt::init(NAMESTR) ;
  if (my_window == NULL) exit(1) ;

  MoMeshViz::init();

  SoSeparator* sep = new SoSeparator;
  
  
  SoShapeHints * sh = new SoShapeHints;
  sh->vertexOrdering.setValue(SoShapeHints::CLOCKWISE);
  sep->addChild(sh);

  MoMesh* moMesh = new MoMesh;
  moMesh->setMesh(mesh);
  sep->addChild(moMesh);

  // Define color map
  MoPredefinedColorMapping* colMap = new MoPredefinedColorMapping;
  // Adjust range to scalar set 1
  colMap->minValue = (float)mesh->getScalarSetIjk("$MyScalarSet")->getMin();
  colMap->maxValue = (float)mesh->getScalarSetIjk("$MyScalarSet")->getMax();
  colMap->predefColorMap = MoPredefinedColorMapping::STANDARD;
  sep->addChild(colMap);

  // First Scalar Value
  MoScalarSetIjk *MoScalarSetI1 = new MoScalarSetIjk;
  MoScalarSetI1->setScalarSet(mesh->getScalarSetIjk("$CellId"));
  sep->addChild(MoScalarSetI1);

  // Second Scalar Value
  MoScalarSetIjk *MoScalarSetI2 = new MoScalarSetIjk;
  MoScalarSetI2->setScalarSet(mesh->getScalarSetIjk("$Sphere"));
  sep->addChild(MoScalarSetI2);
 
  // Third Scalar Value
  MoScalarSetIjk *MoScalarSetI3 = new MoScalarSetIjk;
  MoScalarSetI3->setScalarSet(mesh->getScalarSetIjk("$MyScalarSet"));
  sep->addChild(MoScalarSetI3);

 Vec3Set myVec3Set(MbVec3<size_t>((size_t)NUMI,(size_t)NUMJ,(size_t)NUMK),MiDataSet::PER_NODE);
  // Vector filed
  MoVec3SetIjk *moVec3SetIjk = new MoVec3SetIjk;
  moVec3SetIjk->setVec3Set(&myVec3Set);
  sep->addChild(moVec3SetIjk);

  MoMeshIsosurface *isosurface = new MoMeshIsosurface;
  sep->addChild(isosurface);
  isosurface->isovalue = 1;
  // Use Scalar set 1 to compute the isosurface
  isosurface->isoScalarSetId = 1;

  // Use Scalar set 2 to color the isosurface
  isosurface->colorScalarSetId = 2;

  MoMeshLogicalSlice *logicalSlice = new MoMeshLogicalSlice;
  logicalSlice->sliceIndex = 5;
  logicalSlice->colorScalarSetId = 2;
  logicalSlice->sliceAxis = MiMesh::DIMENSION_J;
  sep->addChild(logicalSlice);

  MoMeshInterpolatedLogicalSlice *interpLogicalSlice = new MoMeshInterpolatedLogicalSlice;
  interpLogicalSlice->sliceValue = 5.3f;
  interpLogicalSlice->colorScalarSetId = 2;
  interpLogicalSlice->sliceAxis = MiMesh::DIMENSION_K;
  sep->addChild(interpLogicalSlice);

  MoMeshPlaneSlice *planeSlice = new MoMeshPlaneSlice;
  planeSlice->plane.setValue(SbPlane(SbVec3f(1,1,1),0.5f));
  planeSlice->colorScalarSetId = 2;
  sep->addChild(planeSlice);

  SoEventCallback *myCallbackNode = new SoEventCallback;
  myCallbackNode->addEventCallback(SoKeyboardEvent::getClassTypeId(), editIsosurface, isosurface); 
  sep->addChild(myCallbackNode);

  // disable for now, cannot connect vectors on isolines connected to an extracted surfaces from a regular mesh
  //SoEventCallback *myCallbackNode2= new SoEventCallback;
  //myCallbackNode2->addEventCallback(SoKeyboardEvent::getClassTypeId(), editSwitch,NULL); 
  //sep->addChild(myCallbackNode2);

  // Transparent Mesh Skin
  SoDrawStyle* style = new SoDrawStyle;
  style->style.setValue(SoDrawStyle::LINES);
  sep->addChild(style);
  SoPickStyle* pickStyle = new SoPickStyle;
  pickStyle->style.setValue(SoPickStyle::UNPICKABLE);
  sep->addChild(pickStyle);

  MoMeshSkin *skin = new MoMeshSkin;
  sep->addChild(skin);
  skin->colorScalarSetId = -1;

  s_min[0] = (float)mesh->getScalarSetIjk("$Sphere")->getMin();
  s_max[0] = (float)mesh->getScalarSetIjk("$Sphere")->getMax();
  s_min[1] = (float)mesh->getScalarSetIjk("$MyScalarSet")->getMin();
  s_max[1] = (float)mesh->getScalarSetIjk("$MyScalarSet")->getMax();
  std::vector<float> isovalues(6);
  computeIsovalues(isovalues, s_min[1], s_max[1]);

  SoGroup* isolines = new SoGroup;
  sep->addChild(isolines);

  // This mesh is used to connect the isosurface generated mesh as input of the isoline
  MoMesh* meshIsoline1 = new MoMesh;
  meshIsoline1->connectFrom(isosurface);
  isolines->addChild(meshIsoline1);

  // Isoline 1
  MoMeshIsoline *isoline1 = new MoMeshIsoline;
  isolines->addChild(isoline1);
  isoline1->isovalues.setValues(0,6,&isovalues[0]);
  isoline1->isoScalarSetId = 2;
  isoline1->colorScalarSetId = 2;

  computeIsovalues(isovalues,s_min[0],s_max[0]);

  // this mesh is used to connect the logical generated mesh as input of the isoline
  MoMesh* meshIsoline2 = new MoMesh;
  meshIsoline2->connectFrom(logicalSlice);
  isolines->addChild(meshIsoline2);

  // Isoline 2
  MoMeshIsoline *isoline2 = new MoMeshIsoline;
  isolines->addChild(isoline2);
  isoline2->isovalues.setValues(0,6,&isovalues[0]);
  // Use Scalar set 1 to compute the isoline: the scalar set is automatically extracted from the isosurface representation.
  isoline2->isoScalarSetId = 1;
  isoline2->colorScalarSetId = 2;

  // This mesh is used to connect the interpolated logical slice generated mesh as input of the isoline
  MoMesh* meshIsoline3 = new MoMesh;
  meshIsoline3->connectFrom(interpLogicalSlice);
  isolines->addChild(meshIsoline3);

  // Isoline 3
  MoMeshIsoline *isoline3 = new MoMeshIsoline;
  isolines->addChild(isoline3);
  isoline3->isovalues.setValues(0,6,&isovalues[0]);
  isoline3->isoScalarSetId = 1;
  isoline3->colorScalarSetId = 2;

  // This mesh is used to connect the plane slice generated mesh as input of the isoline
  MoMesh* meshIsoline4 = new MoMesh;
  meshIsoline4->connectFrom(planeSlice);
  isolines->addChild(meshIsoline4);

  // Isoline 4
  MoMeshIsoline *isoline4 = new MoMeshIsoline;
  isolines->addChild(isoline4);
  isoline4->isovalues.setValues(0,6,&isovalues[0]);
  isoline4->isoScalarSetId = 1;
  isoline4->colorScalarSetId = 2;

  // This mesh is used to connect the skin generated mesh as input of the isoline
  MoMesh* meshIsoline5 = new MoMesh;
  meshIsoline5->connectFrom(skin);
  isolines->addChild(meshIsoline5);

  // Isoline 5
  MoMeshIsoline *isoline5 = new MoMeshIsoline;
  isolines->addChild(isoline5);
  isoline5->isovalues.setValues(0,6,&isovalues[0]);
  isoline5->isoScalarSetId = 1;
  isoline5->colorScalarSetId = 2;

  SoEventCallback *myCallbackNode3 = new SoEventCallback;
  myCallbackNode3->addEventCallback(SoKeyboardEvent::getClassTypeId(), editIsolines, isolines); 
  sep->addChild(myCallbackNode3);

  // This mesh is used to connect the vectors generated mesh as input of the isoline
  MoMesh* isolineMesh = new MoMesh;
  isolineMesh->connectFrom(isoline1);
  sep->addChild(isolineMesh);

  // Display vector on clipline
  m_vectorSwitch = new SoSwitch;
  sep->addChild(m_vectorSwitch);
  MoMeshVector *vector2 = new MoMeshVector;
  vector2->colorScalarSetId = 2;
  m_vectorSwitch->addChild(vector2);

  // Display
  SoXtExaminerViewer* viewer = new SoXtExaminerViewer(my_window);
  viewer->setSceneGraph(sep);
  viewer->setSize(SbVec2s(1024,768));
  viewer->show();
  viewer->viewAll();

  // dialog
  SoXt::show(my_window);
  SoXt::mainLoop();

  delete viewer;

  MoMeshViz::finish();
  SoXt::finish();

  return 0;
}

#ifdef _MSC_VER
#pragma warning( pop ) 
#endif

