#include "DemoIsosurface.h"

#include <Inventor/nodes/SoEventCallback.h>
#include <Inventor/nodes/SoSwitch.h>
#include <Inventor/manips/SoClipPlaneManip.h>
#include <Inventor/events/SoKeyboardEvent.h> 
#include <MeshVizXLM/mapping/nodes/MoScalarSet.h>
#include <MeshVizXLM/mapping/nodes/MoMeshIsosurface.h>
#include <MeshVizXLM/mapping/nodes/MoMeshVector.h>
#include <MeshVizXLM/mapping/nodes/MoDrawStyle.h>
#include <MeshVizXLM/mapping/nodes/MoMaterial.h>

using namespace::std;

//---------------------------------------------------------------------
DemoIsosurface::DemoIsosurface() :
Demo("MeshVizXLM Isosurface",VOLUME_MESH_REGULAR,ALL_VOLUME_MESHES,true)
{
}

//---------------------------------------------------------------------
bool DemoIsosurface::displayInstructions() const
{
  cout << "Press v to toggle vector visibility" << endl;
  return true;
}

//---------------------------------------------------------------------
void DemoIsosurface::keyPressed(SoEventCallback *eventCB)
{
  const SoEvent *ev = eventCB->getEvent();

  if (!eventCB->isHandled())
  {
    if (SO_KEY_PRESS_EVENT(ev, U)) 
    {
      m_isosurface->isovalue.setValue(m_isosurface->isovalue.getValue()+4);
      eventCB->setHandled();
    } 
    else if (SO_KEY_PRESS_EVENT(ev, D) )
    {
      m_isosurface->isovalue.setValue(m_isosurface->isovalue.getValue()-4);
      eventCB->setHandled();
    }
    if (SO_KEY_PRESS_EVENT(ev, V) )
    {
      m_vectorSwitch->whichChild = ( m_vectorSwitch->whichChild.getValue()==SO_SWITCH_ALL) ? SO_SWITCH_NONE : SO_SWITCH_ALL;
      eventCB->setHandled();
    }  
  }
}

//---------------------------------------------------------------------
void DemoIsosurface::getMeshAttributes(MoDrawStyle*& ds, MoMaterial*& mat, SoDrawStyle*& /*ids*/, SoPickStyle*& ps)
{
  ps = new SoPickStyle;
  ds = m_ds = new MoDrawStyle;
  mat = m_mat = new MoMaterial;
  ps->style = SoPickStyle::UNPICKABLE;
  m_ds->displayFaces = false;
  m_ds->displayEdges = true;
  m_mat->lineColor.setValue(SbColor(0,0,0));
}

//---------------------------------------------------------------------
void DemoIsosurface::insertRepresentations(SoSeparator* sep)
{
  // Define color map
  MoPredefinedColorMapping* colMap = new MoPredefinedColorMapping;
  // Adjust range to scalar set 1
  colMap->minValue = (float)this->getScalarSet("$MyScalarSet")->getMin();
  colMap->maxValue = (float)this->getScalarSet("$MyScalarSet")->getMax();
  colMap->predefColorMap = MoPredefinedColorMapping::BLUE_RED;
  sep->addChild(colMap);

  m_isoSet = new MoScalarSet;
  m_isoSet->setScalarSet(this->getScalarSet("$Sphere"));
  sep->addChild(m_isoSet);
  m_colorSet = new MoScalarSet;
  m_colorSet->setScalarSet(this->getScalarSet("$MyScalarSet"));
  sep->addChild(m_colorSet);

  m_isosurface = new MoMeshIsosurface;
  m_isosurface->isovalue = 100;
  m_isosurface->isoScalarSetId = 0;
  m_isosurface->colorScalarSetId = 1;
  sep->addChild(m_isosurface);

  m_vectorSwitch = new SoSwitch;
  MoMesh* isoMesh = new MoMesh;
  isoMesh->connectFrom(m_isosurface);
  
  sep->addChild(m_vectorSwitch);
  {
    m_vectorSwitch->addChild(isoMesh);
    MoMeshVector* vector = new MoMeshVector;
    vector->scaleFactor = 0.1f;
    vector->thicknessFactor = 0.5f;
    m_vectorSwitch->addChild(vector);
  }
}

//---------------------------------------------------------------------
void DemoIsosurface::editInputMesh(SoEventCallback *eventCB)
{
  Demo::editInputMesh(eventCB);
  // mesh has changed update the scalarsets
  m_isoSet->setScalarSet(this->getScalarSet("$Sphere"));
  m_colorSet->setScalarSet(this->getScalarSet("$MyScalarSet"));
}
