#include <MbSampleMeshBuilder.h>

#include <MeshVizXLM/mapping/MoMeshViz.h>
#include <MeshVizXLM/mapping/nodes/MoMesh.h>
#include <MeshVizXLM/mapping/nodes/MoScalarSetIj.h>
#include <MeshVizXLM/mapping/nodes/MoLevelColorMapping.h>
#include <MeshVizXLM/mapping/nodes/MoLinearColorMapping.h>
#include <MeshVizXLM/mapping/nodes/MoMeshSurface.h>
#include <MeshVizXLM/mapping/nodes/MoMeshOutline.h>
#include <MeshVizXLM/mapping/nodes/MoMaterial.h>
#include <MeshVizXLM/mapping/nodes/MoDrawStyle.h>

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoSwitch.h>
#include <Inventor/nodes/SoEventCallback.h>
#include <Inventor/nodes/SoCallback.h>
#include <Inventor/events/SoKeyboardEvent.h> 

#include <Inventor/STL/iostream>
#include <Inventor/STL/vector>
using namespace std;

#define NAMESTR "MeshVizXLM material and draw style test program "

#if defined(_MSC_VER)
#pragma warning( push )
#pragma warning(disable:4250)
#endif

void
editDrawStyle(void *userData, SoEventCallback *eventCB)
{
  bool handled = false;
  const SoEvent *ev = eventCB->getEvent();

  MoDrawStyle *ds = (MoDrawStyle*) (userData);
  if (ds) {
    if (SO_KEY_PRESS_EVENT(ev,F)) // Facet on/off
    {
      ds->displayFaces = ds->displayFaces.getValue() == TRUE ? false : true;
      handled = true;
    } 
    if (SO_KEY_PRESS_EVENT(ev,E)) // Edges on/off
    {
      ds->displayEdges = ds->displayEdges.getValue() == TRUE ? false : true;
      handled = true;
    } 
    if (SO_KEY_PRESS_EVENT(ev,P)) // Edges on/off
    {
      ds->displayPoints = ds->displayPoints.getValue() == TRUE ? false : true;
      handled = true;
    } 
  }
  if (handled) 
    eventCB->setHandled();
}

void
switchMatAndDS(void *userData, SoEventCallback *eventCB)
{
  const SoEvent *ev = eventCB->getEvent();

  SoSwitch *sw = (SoSwitch*) (userData);
  if (sw) {
    if (SO_KEY_PRESS_EVENT(ev,M))
    {
      sw->whichChild = (sw->whichChild.getValue() == SO_SWITCH_NONE) ? SO_SWITCH_ALL : SO_SWITCH_NONE;
    } 
  }
}

void
editSurface(void *userData, SoEventCallback *eventCB)
{
  const SoEvent *ev = eventCB->getEvent();

  SoSwitch *sw = (SoSwitch*) (userData);
  if (sw) {
    if (SO_KEY_PRESS_EVENT(ev,S))
    {
      sw->whichChild = (sw->whichChild.getValue() == 0) ? 1 : 0;
    } 
  }
}

void
editColorMap(void *userData, SoEventCallback *eventCB)
{
  bool handled = false;
  const SoEvent *ev = eventCB->getEvent();

  SoSwitch *sw = (SoSwitch*) (userData);
  if (sw) {
    if (SO_KEY_PRESS_EVENT(ev,F1)) // Level Colormap
    {
      sw->whichChild = 0;
      handled = true;
    } 
    if (SO_KEY_PRESS_EVENT(ev,F2)) // Linear Colormap
    {
      sw->whichChild = 1;
      handled = true;
    } 
  }
  if (handled) 
    eventCB->setHandled();
}

void
editColoring(void *userData, SoEventCallback *eventCB)
{
  bool handled = false;
  const SoEvent *ev = eventCB->getEvent();

  MoMaterial *mat = (MoMaterial*) (userData);
  if (mat) {
    if (SO_KEY_PRESS_EVENT(ev,NUMBER_1)) // FACET CONTOURING
    {
      mat->faceColoring = MoMaterial::CONTOURING;
      handled = true;

    } 
    else if (SO_KEY_PRESS_EVENT(ev, NUMBER_2) ) // FACET UNIFORM COLOR
    {
      mat->faceColoring = MoMaterial::COLOR;
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev,NUMBER_3)) // LINE CONTOURING
    {
      mat->lineColoring = MoMaterial::CONTOURING;
      handled = true;
    } 
    else if (SO_KEY_PRESS_EVENT(ev,NUMBER_4)) // LINE UNIFORM COLOR
    {
      mat->lineColoring = MoMaterial::COLOR;
      handled = true;
    } 
    else if (SO_KEY_PRESS_EVENT(ev,NUMBER_5)) // POINT CONTOURING
    {
      mat->pointColoring = MoMaterial::CONTOURING;
      handled = true;
    } 
    else if (SO_KEY_PRESS_EVENT(ev,NUMBER_6)) // POINT UNIFORM COLOR
    {
      mat->pointColoring = MoMaterial::COLOR;
      handled = true;
    } 
  }


  if (handled) 
    eventCB->setHandled();
}

//-----------------------------------------------------------------------------
int
main(int, char **)
{
  cout << "Press S to switch from surface to outline" << endl;
  cout << "Press M to disable drawstyle and material" << endl;
  cout << "Press 1 for contouring on facets (only for surface)" << endl;
  cout << "Press 2 for uniform color of facets (only for surface)" << endl;
  cout << "Press 3 for contouring on edges" << endl;
  cout << "Press 4 for uniform color of edges" << endl;
  cout << "Press 5 for contouring on points" << endl;
  cout << "Press 6 for uniform color of points" << endl;
  cout << "Press F to toggle face display (only for surface)" << endl;
  cout << "Press E to toggle edge display" << endl;
  cout << "Press P to toggle point display" << endl;
  cout << "Press F1 to switch to level color map" << endl;
  cout << "Press F2 to switch to linear color map" << endl;

  int numLevels = 30;
  MbSampleMeshBuilder<MbVec3f,float> meshBuilder;
  MbSurfaceMeshCurvilinear<MbVec3f,float,MbVec3f>& mesh = meshBuilder.getSurfaceMeshCurvilinear(numLevels,numLevels,MbVec3f(10,10,10),MbVec3f(1,0,0),MbVec3f(0,1,0));
  const MbScalarSetIj<float>* scalarSet = mesh.getScalarSet(1);
  // Init viewer
  Widget my_window = SoXt::init(NAMESTR) ;
  if (my_window == NULL) exit(1) ;

  MoMeshViz::init();

  SoSeparator* sep = new SoSeparator;
  
  SoShapeHints * sh = new SoShapeHints;
  sh->vertexOrdering.setValue(SoShapeHints::CLOCKWISE);
  sep->addChild(sh);

  MoMesh* moMesh = new MoMesh;
  moMesh->setMesh(&mesh);
  sep->addChild(moMesh);

  // Create a Switch to select the Level or Linear colormap to use
  SoSwitch* sw = new SoSwitch;
  sep->addChild(sw);
  sw->whichChild = 0;
  
  // First child: level colormap
  MoLevelColorMapping* colMap = new MoLevelColorMapping;
  int i;
  int numIsoValues = numLevels/5;
  
  float vmin = (float)scalarSet->getMin();
  float vmax = (float)scalarSet->getMax();
  float delta = (vmax-vmin)/(numIsoValues-1);
  float val = vmin;
  for (i=0 ; i < numIsoValues ; i++, val+=delta)
  {
    colMap->values.set1Value(i,val);
  }

  for (i=0 ; i< numIsoValues-1 ; i++)
  {
    if (i<numIsoValues/2)
      colMap->colors.set1Value(i,SbColorRGBA(1,0,2*float(i)/float(numIsoValues-2),0));
    else
      colMap->colors.set1Value(i,SbColorRGBA(2*(1-float(i)/float(numIsoValues-2)),0,1,0));
  }

  sw->addChild(colMap);

  // Second child: linear colormap
  MoLinearColorMapping* colMap2 = new MoLinearColorMapping;
   delta = (vmax-vmin)/(numIsoValues);
  val = vmin;
  for (i=0 ; i < numIsoValues ; i++, val+=delta)
  {
    colMap2->values.set1Value(i,val);
   
    if (i<numIsoValues/2)
      colMap2->colors.set1Value(i,SbColorRGBA(1,0,2*float(i)/float(numIsoValues-1),1));
    else
      colMap2->colors.set1Value(i,SbColorRGBA(2*(1-float(i)/float(numIsoValues-1)),0,1,1));
  }

  sw->addChild(colMap2);

  // Call back to switch colormap
  SoEventCallback *myCallbackNodeCmap = new SoEventCallback;
  myCallbackNodeCmap->addEventCallback(SoKeyboardEvent::getClassTypeId(), editColorMap, sw); 
  sep->addChild(myCallbackNodeCmap);
 

  // Scalar Value
  MoScalarSetIj *MoScalarSetIj2 = new MoScalarSetIj;
  MoScalarSetIj2->setScalarSet(scalarSet);
  sep->addChild(MoScalarSetIj2);

  SoSwitch *sw2 = new SoSwitch;
  sep->addChild(sw2);
  sw2->whichChild = SO_SWITCH_ALL;

  MoDrawStyle* style = new MoDrawStyle;
  style->displayFaces = true;
  style->displayEdges = true;
  style->displayPoints = false;
  sw2->addChild(style);

  MoMaterial* mat = new MoMaterial;
  sw2->addChild(mat);
  mat->faceColoring = MoMaterial::CONTOURING;
  mat->faceColor = SbColor(0.8f,0.8f,0.8f);
  mat->lineColoring = MoMaterial::COLOR;
  mat->lineColor = SbColor(1,0,0);
  
  SoEventCallback *myCallbackNode = new SoEventCallback;
  myCallbackNode->addEventCallback(SoKeyboardEvent::getClassTypeId(), editColoring, mat); 
  sep->addChild(myCallbackNode);
 
  SoEventCallback *myCallbackNode2 = new SoEventCallback;
  myCallbackNode2->addEventCallback(SoKeyboardEvent::getClassTypeId(), editDrawStyle, style); 
  sep->addChild(myCallbackNode2);

  SoEventCallback *myCallbackNode3 = new SoEventCallback;
  myCallbackNode3->addEventCallback(SoKeyboardEvent::getClassTypeId(), switchMatAndDS, sw2); 
  sep->addChild(myCallbackNode3);
 
  SoSwitch *soswitch = new SoSwitch;
  sep->addChild(soswitch);
  soswitch->whichChild = 0;

  MoMeshSurface *surface = new MoMeshSurface;
  surface->colorScalarSetId = 0;
  soswitch->addChild(surface);

  MoMeshOutline *outline = new MoMeshOutline;
  soswitch->addChild(outline);

  SoEventCallback *myCallbackNode4 = new SoEventCallback;
  myCallbackNode4->addEventCallback(SoKeyboardEvent::getClassTypeId(), editSurface, soswitch); 
  sep->addChild(myCallbackNode4);

  SoXtExaminerViewer* viewer = new SoXtExaminerViewer(my_window);
  viewer->setSceneGraph(sep);
  viewer->setSize(SbVec2s(1024,768));
  viewer->show();
  viewer->viewAll();

  // dialog
  SoXt::show(my_window);
  SoXt::mainLoop();

  delete viewer;

  MoMeshViz::finish();
  SoXt::finish();

  return 0;
}

#if defined(_MSC_VER)
#pragma warning( pop ) 
#endif

