#include "DemoOutline.h"

#include <Inventor/nodes/SoEventCallback.h>
#include <Inventor/nodes/SoSwitch.h>
#include <Inventor/manips/SoClipPlaneManip.h>
#include <Inventor/events/SoKeyboardEvent.h> 
#include <MeshVizXLM/mapping/nodes/MoScalarSet.h>
#include <MeshVizXLM/mapping/nodes/MoMeshOutline.h>
#include <MeshVizXLM/mapping/nodes/MoMeshVector.h>
#include <MeshVizXLM/mapping/nodes/MoDrawStyle.h>
#include <MeshVizXLM/mapping/nodes/MoMaterial.h>

using namespace::std;

//---------------------------------------------------------------------
DemoOutline::DemoOutline() :
Demo("MeshVizXLM Outline",VOLUME_MESH_REGULAR,ALL_SURFACE_VOLUME_MESHES,true)
{
}

//---------------------------------------------------------------------
bool DemoOutline::displayInstructions() const
{
  cout << "Press s to toggle skin/surface visibility" << endl;
  cout << "Press v to toggle vector visibility" << endl;
  return true;
}

//---------------------------------------------------------------------
void DemoOutline::keyPressed(SoEventCallback *eventCB)
{
  const SoEvent *ev = eventCB->getEvent();

  if (!eventCB->isHandled())
  {
    if (SO_KEY_PRESS_EVENT(ev, S)) 
    {
      m_ds->displayEdges = !m_ds->displayEdges.getValue();
      eventCB->setHandled();
    } 
    if (SO_KEY_PRESS_EVENT(ev, V) )
    {
      m_vectorSwitch->whichChild = ( m_vectorSwitch->whichChild.getValue()==SO_SWITCH_ALL) ? SO_SWITCH_NONE : SO_SWITCH_ALL;
      eventCB->setHandled();
    }  
  }
}

//---------------------------------------------------------------------
void DemoOutline::getMeshAttributes(MoDrawStyle*& ds, MoMaterial*& mat, SoDrawStyle*& /*ids*/, SoPickStyle*& ps)
{
  ps = new SoPickStyle;
  ds = m_ds = new MoDrawStyle;
  mat = m_mat = new MoMaterial;
  mat->lineColoring = MoMaterial::COLOR;
  mat->lineColor = SbColor(1,1,1);
  ps->style = SoPickStyle::UNPICKABLE;
  m_ds->displayFaces = false;
  m_ds->displayEdges = true;
}

//---------------------------------------------------------------------
void DemoOutline::insertRepresentations(SoSeparator* sep)
{
  MoMeshOutline* outline = new MoMeshOutline;

  m_vectorSwitch = new SoSwitch;
  MoMesh* outlineMesh = new MoMesh;
  outlineMesh->connectFrom(outline);
  
  sep->addChild(outline);
  sep->addChild(m_vectorSwitch);
  {
    m_vectorSwitch->addChild(outlineMesh);
    MoMeshVector* vector = new MoMeshVector;
    vector->scaleFactor = 0.1f;
    vector->thicknessFactor = 0.5f;
    m_vectorSwitch->addChild(vector);
  }
}
