#include <MeshVizXLM/mesh/cell/MiCellFilterIjk.h>
#include <MeshVizXLM/mesh/cell/MiCellFilterIj.h>
#include <MeshVizXLM/extractors/MiExtractorCallback.h>

#include <MbSampleMeshBuilder.h>
#include <data/MbVec3SetI.h>

#include <colormapping/MbLinearColorMapping.h>
#include <colormapping/MbLevelColorMapping.h>

#include <MeshVizXLM/mapping/MoMeshViz.h>
#include <MeshVizXLM/mapping/nodes/MoMesh.h>
#include <MeshVizXLM/mapping/nodes/MoScalarSetI.h>
#include <MeshVizXLM/mapping/nodes/MoScalarSetIj.h>
#include <MeshVizXLM/mapping/nodes/MoScalarSetIjk.h>
#include <MeshVizXLM/mapping/nodes/MoVec3SetIjk.h>
#include <MeshVizXLM/mapping/nodes/MoVec3SetIj.h>
#include <MeshVizXLM/mapping/nodes/MoVec3SetI.h>
#include <MeshVizXLM/mapping/nodes/MoPredefinedColorMapping.h>
#include <MeshVizXLM/mapping/nodes/MoCustomColorMapping.h>
#include <MeshVizXLM/mapping/nodes/MoMeshSkin.h>
#include <MeshVizXLM/mapping/nodes/MoMeshOutline.h>
#include <MeshVizXLM/mapping/nodes/MoMeshVector.h>
#include <MeshVizXLM/mapping/nodes/MoMeshSurface.h>
#include <MeshVizXLM/mapping/nodes/MoDataBinding.h>
#include <MeshVizXLM/mapping/nodes/MoCellFilter.h>

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoCube.h>
#include <Inventor/nodes/SoSwitch.h>
#include <Inventor/nodes/SoTranslation.h>
#include <Inventor/nodes/SoEventCallback.h>
#include <Inventor/nodes/SoCallback.h>
#include <Inventor/events/SoKeyboardEvent.h> 

#include <Inventor/manips/SoClipPlaneManip.h>

#include "../DemoTemplate/Vec3Set.h"

#include <Inventor/STL/iostream>
#include <Inventor/STL/fstream>
#include <Inventor/STL/vector>
using namespace std;

#define NAMESTR "MeshVizXLM Sample program"

MbLinearColorMapping<double,SbColorRGBA,float> linearColorMap;
MbLevelColorMapping<double,SbColorRGBA> levelColorMapping;

#pragma warning( push )
#pragma warning(disable:4250)

#define NUM_CELL_I 10
#define NUM_CELL_J 5
#define NUM_CELL_K 20
#define STEPI      1
#define STEPJ      1

SoSwitch* m_vectorSwitch;
SoSwitch* m_skinsurfSwitch;
SoSwitch* m_skinSwitch;
SoSwitch* m_surfaceSwitch;
SoSwitch* m_filterSwitch;
static MbSampleMeshBuilder<MbVec3d,double> meshBuilder;

class MyExtractorCallback : public MiExtractorCallback
{
public:
  void beginExtract(const std::string name, bool /*geomChanged*/, bool topoChanged, bool dataSetChanged, size_t) 
  {
    if(topoChanged)
    std::cout << name << " computation started..." << endl;
    if(dataSetChanged)
    std::cout << name << " dataset computation started..." << endl;
  }

  void endExtract()
  {
    std::cout << "computation finished" << endl;
  }
  bool beginPhase(size_t , std::string , size_t ) { return false; }
  bool endPhase() { return false; }
  bool endStep(size_t ) { return false; }
  double getEndStepCallPeriod() { return 0; }
};

class MyCellFilterIjk : public MiCellFilterIjk
{
public:
  virtual bool acceptCell(size_t i, size_t j, size_t /*k*/) const 
  { 
    // Compute any random function 
    if (((NUM_CELL_I/3.0f)<i && i<=(2*NUM_CELL_I/3.0f)) && ((NUM_CELL_J/3.0f)<j && j<=(2*NUM_CELL_J/3.0f))) return false;
    else return true;
  }
  virtual size_t getTimeStamp() const { return 0; }
};
MyCellFilterIjk m_cellFilterIjk;

class MyCellFilterIj : public MiCellFilterIj
{
public:
  virtual bool acceptCell(size_t i, size_t j) const 
  { 
    // Compute any random function 
    if (((NUM_CELL_I/3.0f)<i && i<=(2*NUM_CELL_I/3.0f)) || ((NUM_CELL_J/3.0f)<j && j<=(2*NUM_CELL_J/3.0f))) return false;
    else return true;
  }
  virtual size_t getTimeStamp() const { return 0; }
};
MyCellFilterIj m_cellFilterIj;
MoCellFilter* m_moCellFilter;

class UserData 
{
public:
  UserData(MoMesh *moMesh, MoScalarSetI *moScalarSetI, MoScalarSetIj *moScalarSetIj, MoScalarSetIjk *moScalarSetIjk, MoPredefinedColorMapping* colMap) :
      m_moMesh(moMesh), m_moScalarSetI(moScalarSetI), m_moScalarSetIj(moScalarSetIj), m_moScalarSetIjk(moScalarSetIjk), m_colMap(colMap) {}

      MoMesh * getMoMesh() { return m_moMesh; }
      MoScalarSetI *getMoScalarSetI() { return m_moScalarSetI;}
      MoScalarSetIj *getMoScalarSetIj() { return m_moScalarSetIj;}
      MoScalarSetIjk *getMoScalarSetIjk() { return m_moScalarSetIjk;}
      MoPredefinedColorMapping* getColorMap() { return m_colMap; }

private:
  MoMesh *m_moMesh;
  MoScalarSetI *m_moScalarSetI;
  MoScalarSetIj *m_moScalarSetIj;
  MoScalarSetIjk *m_moScalarSetIjk;
  MoPredefinedColorMapping* m_colMap;
};

void
editOutline(void *userData, SoEventCallback *eventCB)
{
  bool handled = false;
  const SoEvent *ev = eventCB->getEvent();

  MoMeshOutline *outline = (MoMeshOutline*) (userData);
  if (outline) {
    if (SO_KEY_PRESS_EVENT(ev, V) )
    {
      m_vectorSwitch->whichChild = ( m_vectorSwitch->whichChild.getValue()==SO_SWITCH_ALL) ? SO_SWITCH_NONE : SO_SWITCH_ALL;
      handled = true;
    }
    if (SO_KEY_PRESS_EVENT(ev, S) )
    {
      m_skinsurfSwitch->whichChild = ( m_skinsurfSwitch->whichChild.getValue()==SO_SWITCH_ALL) ? SO_SWITCH_NONE : SO_SWITCH_ALL;
      handled = true;
    }
    if (SO_KEY_PRESS_EVENT(ev, F) )
    {
      m_filterSwitch->whichChild = ( m_filterSwitch->whichChild.getValue()==SO_SWITCH_ALL) ? SO_SWITCH_NONE : SO_SWITCH_ALL;
      handled = true;
    }
  }
  if (handled)
    eventCB->setHandled();
}

void
editMesh(void *userData, SoEventCallback *eventCB)
{
  const SoEvent *ev = eventCB->getEvent();

  bool handled = false;
  MbVec3<size_t> dim(NUM_CELL_I,NUM_CELL_J,NUM_CELL_K);
  MbVec3d dimmax(NUM_CELL_I,NUM_CELL_J,NUM_CELL_K);
  MbVec3d stepI(STEPI,0,0);
  MbVec3d stepJ(0,STEPJ,0);

  UserData* myUserData = (UserData*) (userData);
  MoMesh *moMesh = myUserData->getMoMesh();
  if (moMesh) {
    if (SO_KEY_PRESS_EVENT(ev, F1))
    {
      cout << "Displaying Tetrahedon mesh" << endl;
      MbVolumeMeshTetrahedron<MbVec3d,double,MbVec3d>* meshTetra = &meshBuilder.getMeshTetrahedron(dim,MbVec3d(0),dimmax);
      moMesh->setMesh(meshTetra);
      MoScalarSetI *moScalarSetI = myUserData->getMoScalarSetI();
      moScalarSetI->setScalarSet(meshTetra->getScalarSet(1));
      myUserData->getColorMap()->minValue = (float)meshTetra->getScalarSet(1)->getMin();
      myUserData->getColorMap()->maxValue = (float)meshTetra->getScalarSet(1)->getMax();
      m_skinSwitch->whichChild = SO_SWITCH_ALL;
      m_surfaceSwitch->whichChild = SO_SWITCH_NONE;
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, F2))
    {
      cout << "Displaying Hexahedron mesh" << endl;
      MbVolumeMeshHexahedron<MbVec3d,double,MbVec3d>* meshHexa = &meshBuilder.getMeshHexahedron(dim,MbVec3d(0),dimmax);
      moMesh->setMesh(meshHexa);
      MoScalarSetI *moScalarSetI = myUserData->getMoScalarSetI();
      moScalarSetI->setScalarSet(meshHexa->getScalarSet(1));
      myUserData->getColorMap()->minValue = (float)meshHexa->getScalarSet(1)->getMin();
      myUserData->getColorMap()->maxValue = (float)meshHexa->getScalarSet(1)->getMax();
      m_skinSwitch->whichChild = SO_SWITCH_ALL;
      m_surfaceSwitch->whichChild = SO_SWITCH_NONE;
      handled = true;

    }
    else if (SO_KEY_PRESS_EVENT(ev, F3))
    {
      cout << "Displaying Regular Volume mesh" << endl;
      MbVolumeMeshRegular<double,double,MbVec3d>* meshIjk = &meshBuilder.getVolumeMeshRegular(dim,MbVec3d(0),dimmax);
      moMesh->setMesh(meshIjk);
      MoScalarSetIjk *moScalarSetIjk = myUserData->getMoScalarSetIjk();
      moScalarSetIjk->setScalarSet(meshIjk->getScalarSetIjk(1));
      myUserData->getColorMap()->minValue = (float)meshIjk->getScalarSetIjk(1)->getMin();
      myUserData->getColorMap()->maxValue = (float)meshIjk->getScalarSetIjk(1)->getMax();
      m_skinSwitch->whichChild = SO_SWITCH_ALL;
      m_surfaceSwitch->whichChild = SO_SWITCH_NONE;
      m_moCellFilter->setCellFilter(&m_cellFilterIjk);
      handled = true;

    }
    else if (SO_KEY_PRESS_EVENT(ev, F4))
    {
      cout << "Displaying Rectilinear Volume mesh" << endl;
      MbVolumeMeshRectilinear<double,double,MbVec3d>* meshIjk = &meshBuilder.getVolumeMeshRectilinear(dim,MbVec3d(0),dimmax);
      moMesh->setMesh(meshIjk);
      MoScalarSetIjk *moScalarSetIjk = myUserData->getMoScalarSetIjk();
      moScalarSetIjk->setScalarSet(meshIjk->getScalarSetIjk(1));
      myUserData->getColorMap()->minValue = (float)meshIjk->getScalarSetIjk(1)->getMin();
      myUserData->getColorMap()->maxValue = (float)meshIjk->getScalarSetIjk(1)->getMax();
      m_skinSwitch->whichChild = SO_SWITCH_ALL;
      m_surfaceSwitch->whichChild = SO_SWITCH_NONE;
      m_moCellFilter->setCellFilter(&m_cellFilterIjk);
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, F5))
    {
      cout << "Displaying Curvilinear Volume mesh" << endl;
      MbVolumeMeshCurvilinear<MbVec3d,double,MbVec3d>* meshIjk = &meshBuilder.getVolumeMeshCurvilinear(dim,MbVec3d(0),dimmax);
      moMesh->setMesh(meshIjk);
      MoScalarSetIjk *moScalarSetIjk = myUserData->getMoScalarSetIjk();
      moScalarSetIjk->setScalarSet(meshIjk->getScalarSetIjk(1));
      myUserData->getColorMap()->minValue = (float)meshIjk->getScalarSetIjk(1)->getMin();
      myUserData->getColorMap()->maxValue = (float)meshIjk->getScalarSetIjk(1)->getMax();
      m_skinSwitch->whichChild = SO_SWITCH_ALL;
      m_surfaceSwitch->whichChild = SO_SWITCH_NONE;
      m_moCellFilter->setCellFilter(&m_cellFilterIjk);
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, F7))
    {
      cout << "Displaying Hexahedron IJK mesh" << endl;
      MbHexahedronMeshIjk<MbVec3d,double,MbVec3d>* meshUIjk = &meshBuilder.getHexahedronMeshIjk(dim,MbVec3d(0),dimmax);
      moMesh->setMesh(meshUIjk);
      MoScalarSetI *moScalarSetI = myUserData->getMoScalarSetI();
      moScalarSetI->setScalarSet(meshUIjk->getScalarSet(1));
      myUserData->getColorMap()->minValue = (float)meshUIjk->getScalarSet(1)->getMin();
      myUserData->getColorMap()->maxValue = (float)meshUIjk->getScalarSet(1)->getMax();
      m_skinSwitch->whichChild = SO_SWITCH_ALL;
      m_surfaceSwitch->whichChild = SO_SWITCH_NONE;
      m_moCellFilter->setCellFilter(&m_cellFilterIjk);
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, F8))
    {
      cout << "Displaying Quadrangle mesh" << endl;
      MbSurfaceMeshQuadrangle<MbVec3d,double,MbVec3d>* meshQuad = &meshBuilder.getSurfaceMeshQuadrangle(NUM_CELL_I,NUM_CELL_J,MbVec3d(0),stepI,stepJ);
      moMesh->setMesh(meshQuad);
      MoScalarSetI *moScalarSetI = myUserData->getMoScalarSetI();
      moScalarSetI->setScalarSet(meshQuad->getScalarSet(1));
      myUserData->getColorMap()->minValue = (float)meshQuad->getScalarSet(1)->getMin();
      myUserData->getColorMap()->maxValue = (float)meshQuad->getScalarSet(1)->getMax();
      m_surfaceSwitch->whichChild = SO_SWITCH_ALL;
      m_skinSwitch->whichChild = SO_SWITCH_NONE;
      handled = true;

    }
    else if (SO_KEY_PRESS_EVENT(ev, F9))
    {
      cout << "Displaying Regular Surface mesh" << endl;
      MbSurfaceMeshRegular<double,double,MbVec3d>* meshIj = &meshBuilder.getSurfaceMeshRegular(NUM_CELL_I,NUM_CELL_J,MbVec3d(0),dimmax);
      moMesh->setMesh(meshIj);
      MoScalarSetIj *moScalarSetIj = myUserData->getMoScalarSetIj();
      moScalarSetIj->setScalarSet(meshIj->getScalarSet(1));
      myUserData->getColorMap()->minValue = (float)meshIj->getScalarSet(1)->getMin();
      myUserData->getColorMap()->maxValue = (float)meshIj->getScalarSet(1)->getMax();
      m_surfaceSwitch->whichChild = SO_SWITCH_ALL;
      m_skinSwitch->whichChild = SO_SWITCH_NONE;
      m_moCellFilter->setCellFilter(&m_cellFilterIj);
      handled = true;

    }
    else if (SO_KEY_PRESS_EVENT(ev, F12))
    {
      cout << "Displaying Rectilinear Surface mesh" << endl;
      MbSurfaceMeshRectilinear<double,double,MbVec3d>* meshIj = &meshBuilder.getSurfaceMeshRectilinear(NUM_CELL_I,NUM_CELL_J,0.0,0.0,NUM_CELL_I,NUM_CELL_J);
      moMesh->setMesh(meshIj);
      MoScalarSetIj *moScalarSetIj = myUserData->getMoScalarSetIj();
      moScalarSetIj->setScalarSet(meshIj->getScalarSet(1));
      myUserData->getColorMap()->minValue = (float)meshIj->getScalarSet(1)->getMin();
      myUserData->getColorMap()->maxValue = (float)meshIj->getScalarSet(1)->getMax();
      m_surfaceSwitch->whichChild = SO_SWITCH_ALL;
      m_skinSwitch->whichChild = SO_SWITCH_NONE;
      m_moCellFilter->setCellFilter(&m_cellFilterIj);
      handled = true;
    }
    else if (SO_KEY_PRESS_EVENT(ev, F11))
    {
      cout << "Displaying Curvilinear Surface mesh" << endl;
      MbSurfaceMeshCurvilinear<MbVec3d,double,MbVec3d>* meshIj = &meshBuilder.getSurfaceMeshCurvilinear(NUM_CELL_I,NUM_CELL_J,MbVec3d(0),stepI,stepJ);
      moMesh->setMesh(meshIj);
      MoScalarSetIj *moScalarSetIj = myUserData->getMoScalarSetIj();
      moScalarSetIj->setScalarSet(meshIj->getScalarSet(1));
      myUserData->getColorMap()->minValue = (float)meshIj->getScalarSet(1)->getMin();
      myUserData->getColorMap()->maxValue = (float)meshIj->getScalarSet(1)->getMax();
      m_surfaceSwitch->whichChild = SO_SWITCH_ALL;
      m_skinSwitch->whichChild = SO_SWITCH_NONE;
      m_moCellFilter->setCellFilter(&m_cellFilterIj);
      handled = true;
    }
  }

  if (handled)
    eventCB->setHandled();

}


//-----------------------------------------------------------------------------
int
main(int, char **)
{
  cout << "Press F1 for Tetrahedon mesh" << endl;
  cout << "Press F2 for Hexahedron mesh" << endl;
  cout << "Press F3 for Regular mesh" << endl;
  cout << "Press F4 for Rectilinear mesh" << endl;
  cout << "Press F5 for Curvilinear mesh" << endl;
  cout << "Press F7 for Hexahedron IJK mesh" << endl;
  cout << "Press F8 for Quadrangle mesh" << endl;
  cout << "Press F9 for Regular Surface mesh" << endl;
  cout << "Press F11 for Curvilinear Surface mesh" << endl;
  cout << "Press F12 for Rectilinear Surface mesh" << endl;
  cout << "Press f to toggle cell filter (structured only)" << endl;
  cout << "Press v to toggle vector visibility" << endl;
  cout << "Press s to toggle skin/surface visibility" << endl;
  cout << "Displaying Hexahedron mesh" << endl;

  // Init viewer
  Widget my_window = SoXt::init(NAMESTR) ;
  if (my_window == NULL) exit(1) ;

  MoMeshViz::init();

  SoSeparator* sep = new SoSeparator;

  SoShapeHints * sh = new SoShapeHints;
  sh->vertexOrdering.setValue(SoShapeHints::CLOCKWISE);
  sep->addChild(sh);

  MbVec3<size_t> dim(NUM_CELL_I,NUM_CELL_J,NUM_CELL_K);
  MbVec3d dimmax(NUM_CELL_I,NUM_CELL_J,NUM_CELL_K);
  MbVolumeMeshHexahedron<MbVec3d,double,MbVec3d>& mesh = meshBuilder.getMeshHexahedron(dim,MbVec3d(0),dimmax);


  MoMesh* moMesh = new MoMesh;
  moMesh->setMesh(&mesh);
  sep->addChild(moMesh);

  m_filterSwitch = new SoSwitch;
  m_filterSwitch->whichChild = SO_SWITCH_NONE;
  m_moCellFilter = new MoCellFilter;
  m_filterSwitch->addChild(m_moCellFilter);
  sep->addChild(m_filterSwitch);

  // Define color map
  MoPredefinedColorMapping* colMap = new MoPredefinedColorMapping;
  // Adjust range to scalar set 1
  colMap->minValue = (float)mesh.getScalarSet(1)->getMin();
  colMap->maxValue = (float)mesh.getScalarSet(1)->getMax();
  colMap->predefColorMap = MoPredefinedColorMapping::STANDARD;
  sep->addChild(colMap);

  // First Scalar Value
  MoScalarSetIjk *moScalarSetIjk = new MoScalarSetIjk;
  MoScalarSetIj *moScalarSetIj = new MoScalarSetIj;
  MoScalarSetI *moScalarSetI = new MoScalarSetI;
  moScalarSetI->setScalarSet(mesh.getScalarSet(1));
  sep->addChild(moScalarSetI);
  sep->addChild(moScalarSetIj);
  sep->addChild(moScalarSetIjk);

  MoDataBinding* dataBinding = new MoDataBinding;
  dataBinding->dataBinding = MoDataBinding::PER_NODE;
  sep->addChild(dataBinding);

  m_skinsurfSwitch = new SoSwitch;
  m_skinsurfSwitch->whichChild = SO_SWITCH_ALL;
  sep->addChild(m_skinsurfSwitch);

  // Transparent Mesh Skin
  SoDrawStyle* style = new SoDrawStyle;
  style->style.setValue(SoDrawStyle::LINES);
  m_skinsurfSwitch->addChild(style);
  SoPickStyle* pickStyle = new SoPickStyle;
  pickStyle->style.setValue(SoPickStyle::UNPICKABLE);
  m_skinsurfSwitch->addChild(pickStyle);

  m_skinSwitch = new SoSwitch;
  m_skinSwitch->whichChild = SO_SWITCH_ALL;
  MoMeshSkin *skin = new MoMeshSkin;
  skin->colorScalarSetId = -1;
  m_skinSwitch->addChild(skin);
  m_skinsurfSwitch->addChild(m_skinSwitch);

  m_surfaceSwitch = new SoSwitch;
  m_surfaceSwitch->whichChild = SO_SWITCH_NONE;
  MoMeshSurface* meshSurface = new MoMeshSurface;
  meshSurface->colorScalarSetId = -1;
  m_surfaceSwitch->addChild(meshSurface);
  m_skinsurfSwitch->addChild(m_surfaceSwitch);

  MyExtractorCallback extCB;
  MoMeshOutline *outline = new MoMeshOutline;
  outline->setExtractorCallback(&extCB);
  sep->addChild(outline);

  SoEventCallback *myCallbackNode1 = new SoEventCallback;
  UserData userData(moMesh,moScalarSetI,moScalarSetIj,moScalarSetIjk,colMap);
  myCallbackNode1->addEventCallback(SoKeyboardEvent::getClassTypeId(), editMesh, &userData); 
  sep->addChild(myCallbackNode1);

  SoEventCallback *myCallbackNode2 = new SoEventCallback;
  myCallbackNode2->addEventCallback(SoKeyboardEvent::getClassTypeId(), editOutline, outline); 
  sep->addChild(myCallbackNode2);

  // This mesh is used to connect the cells generated mesh as input of the vectors
  MoMesh* outlineMesh = new MoMesh;
  outlineMesh->connectFrom(outline);
  sep->addChild(outlineMesh);

  Vec3Set myVec3Set(MbVec3<size_t>((size_t)NUM_CELL_I,(size_t)NUM_CELL_J,(size_t)NUM_CELL_K),MiDataSet::PER_NODE);
  // Vector filed
  MoVec3SetI *moVec3SetI = new MoVec3SetI;
  moVec3SetI->setVec3Set(&myVec3Set);
  sep->addChild(moVec3SetI);
  MoVec3SetIjk *moVec3SetIjk = new MoVec3SetIjk;
  moVec3SetIjk->setVec3Set(&myVec3Set);
  sep->addChild(moVec3SetIjk);
  MoVec3SetIj *moVec3SetIj = new MoVec3SetIj;
  moVec3SetIj->setVec3Set(&myVec3Set);
  sep->addChild(moVec3SetIj);

  // Display vector on grid
  m_vectorSwitch = new SoSwitch;
  sep->addChild(m_vectorSwitch);
  MoMeshVector *vector = new MoMeshVector;
  m_vectorSwitch->addChild(vector);

  SoXtExaminerViewer* viewer = new SoXtExaminerViewer(my_window);
  viewer->setSceneGraph(sep);
  viewer->setSize(SbVec2s(1024,768));
  viewer->show();
  viewer->viewAll();

  // dialog
  SoXt::show(my_window);
  SoXt::mainLoop();

  delete viewer;

  MoMeshViz::finish();
  SoXt::finish();

  return 0;
}


#pragma warning( pop ) 


