#include "DemoOutlineOnPlaneSlice.h"

#include <Inventor/nodes/SoEventCallback.h>
#include <Inventor/events/SoKeyboardEvent.h> 
#include <Inventor/manips/SoClipPlaneManip.h>
#include <Inventor/nodes/SoPickStyle.h>
#include <Inventor/nodes/SoLightModel.h>
#include <Inventor/nodes/SoSwitch.h>

#include <MeshVizXLM/mapping/nodes/MoDrawStyle.h>
#include <MeshVizXLM/mapping/nodes/MoMaterial.h>
#include <MeshVizXLM/mapping/nodes/MoMesh.h>
#include <MeshVizXLM/mapping/nodes/MoMeshPlaneSlice.h>
#include <MeshVizXLM/mapping/nodes/MoMeshOutline.h>

//---------------------------------------------------------------------
DemoOutlineOnPlaneSlice::DemoOutlineOnPlaneSlice() : 
Demo("MeshVizXLM Outline On PlaneSlice",VOLUME_MESH_UNSTRUCTURED,NONE,
     false,MiDataSet::PER_CELL,MbVec3<size_t>(2,2,2)) 
{
}

//---------------------------------------------------------------------
DemoOutlineOnPlaneSlice::~DemoOutlineOnPlaneSlice()
{
}

//---------------------------------------------------------------------
void DemoOutlineOnPlaneSlice::keyPressed(SoEventCallback *eventCB)
{
  const SoEvent *ev = eventCB->getEvent();
  bool handled = true;

  if (SO_KEY_PRESS_EVENT(ev, P) )
    m_planeSliceDStyle->displayFaces = !m_planeSliceDStyle->displayFaces.getValue();
  else if (SO_KEY_PRESS_EVENT(ev, O)) 
    if (m_outline->colorScalarSetId.getValue() == -1)
      m_outline->colorScalarSetId = 0;
    else
      m_outline->colorScalarSetId = -1;
  else
    handled = false;

  if (handled) 
    eventCB->setHandled();
}

//---------------------------------------------------------------------
bool DemoOutlineOnPlaneSlice::displayInstructions() const
{
  cout << "Click on the arrow icon then move the dragger around." << endl;
  cout << "Press O to toggle color mapping on the outline " << endl;
  cout << "Press P to toggle the plane slice visibility " << endl << endl;
  return true;
}

//---------------------------------------------------------------------
void DemoOutlineOnPlaneSlice::getMeshAttributes(MoDrawStyle*& ds, MoMaterial*& mat, SoDrawStyle*& /*ids*/, SoPickStyle*& ps)
{
  ds = new MoDrawStyle;
  mat = new MoMaterial;
  ds->displayFaces = false;
  ds->displayEdges = true;
  mat->lineColoring = MoMaterial::COLOR;
  mat->lineColor.setValue(SbColor(1.0,1.0,1.0));
  ps = new SoPickStyle;
  ps->style = SoPickStyle::UNPICKABLE;
}

//---------------------------------------------------------------------
void DemoOutlineOnPlaneSlice::insertRepresentations(SoSeparator* sep)
{
  // Manipulator to move the plane slice plane (as a clip plane)
  SoClipPlaneManip *manip = new SoClipPlaneManip;
  manip->plane.setValue(SbPlane(SbVec3f(1,0,1),5.0f));
  // Turn off clip plane visibility to avoid flickering of plane slice faces.
  manip->on.setValue(FALSE); 
  manip->draggerPosition.setValue(this->getCenter());
  sep->addChild(manip);

  m_planeSliceDStyle = new MoDrawStyle;
  sep->addChild(m_planeSliceDStyle);

  MoMeshPlaneSlice* slice = new MoMeshPlaneSlice;
  slice->colorScalarSetId = 0;
  slice->plane.connectFrom(&manip->plane);
  sep->addChild(slice);

  MoMesh* sliceMesh = new MoMesh;
  sliceMesh->connectFrom(slice);
  sep->addChild(sliceMesh);

  MoDrawStyle* ds = new MoDrawStyle;
  ds->displayEdges = true;
  sep->addChild(ds);

  m_outline = new MoMeshOutline;
  m_outline->colorScalarSetId = -1;
  sep->addChild(m_outline);
}

