#include "DemoPicking.h"

#include <Inventor/SoPickedPoint.h>
#include <Inventor/nodes/SoEventCallback.h>
#include <MeshVizXLM/mapping/details/MoFaceDetailI.h>
#include <MeshVizXLM/mapping/details/MoMeshDetail.h>

using namespace::std;

//---------------------------------------------------------------------
DemoPicking::DemoPicking() : Demo("MeshVizXLM Picking",VOLUME_MESH_UNSTRUCTURED) 
{
}

//---------------------------------------------------------------------
DemoPicking::~DemoPicking()
{
  delete m_textEditor;
}

//---------------------------------------------------------------------
// Method called each time the mouse is moved in the viewer window
void DemoPicking::mouseMoved(SoEventCallback *eventCB)
{
  // Get the picked point (if any)
  // Picking is automatically performed using the event location
  const SoPickedPoint *pickedPoint = eventCB->getPickedPoint();
  if (pickedPoint) 
  {
    // Something has been picked : It could be either an Open Inventor shape 
    // like SoCone or a mesh representation. Get detail and check type.
    const SoDetail* detail = pickedPoint->getDetail();
    if (detail->isOfType(MoFaceDetailI::getClassTypeId()))
    {
      // A face of a mesh representation of a unstructured mesh 
      // has been picked. Get detail about the picked face.
      MoFaceDetailI* fdetail = (MoFaceDetailI*) detail;

      // Get the picked cell and the value at the picked point.
      size_t cellId = fdetail->getCellIndex();
      double value = fdetail->getValue(pickedPoint->getPoint());
      
      // Get detail about the picked mesh 
      const MoMeshDetail* mdetail = fdetail->getMeshDetail();
      MeshType meshType = mdetail->getMeshType();
      std::string colorName = mdetail->getColorScalarSet()->getName();
      // Process the detail information retreived by picking, 
      // for example...
      m_textEditor->edit(cellId,value,meshType,colorName);

      // Note: The pickedMesh can be cast to the application
      // real mesh class in order to get any application data.
    }
    else
      // other representation of mesh (see MoFaceDetailIj, MoLineDetailI, etc)
      // or Inventor shape picked
      m_textEditor->clear();
  }
  else 
    // nothing picked
    m_textEditor->clear();
  eventCB->setHandled();
}

//---------------------------------------------------------------------
bool DemoPicking::displayInstructions() const
{
  cout << "Click on the arrow icon then move the cursor over the mesh skin." << endl << endl;
  return true;
}

//---------------------------------------------------------------------
void DemoPicking::insertScene2D(SoSeparator* sep)
{
  m_textEditor = new TextSceneEditor(sep);
}

