#ifndef  _DemoPickingAndProbing_h
#define  _DemoPickingAndProbing_h

#include "../DemoTemplate/Demo.h"
#include "../DemoTemplate/TextSceneEditor.h"

#include <MeshVizXLM/mapping/nodes/MoMeshPointProbe.h>
#include <MeshVizXLM/extrmesh/data/MeXDataSetI.h>
#include <MeshVizXLM/extrmesh/data/MeXDataSetIj.h>
#include <MeshVizXLM/extrmesh/data/MeXDataSetIjk.h>
#include <MeshVizXLM/mesh/cell/MiCellFilterIjk.h>

class SoPickStyle;
class SoSwitch;

class DemoPickingAndProbing : public Demo, public MoMeshPointProbe::MoProbeCallback
{
public:
  DemoPickingAndProbing();
  ~DemoPickingAndProbing();

  virtual void keyPressed(SoEventCallback *eventCB);
  virtual void mouseMoved(SoEventCallback *eventCB);

  // Probe callback
  void motionCallback(size_t cellId, const MeXScalardSetI& scalars, const MeXVec3dSetI& vectors);
  void motionCallback(size_t cellIdI,size_t cellIdJ, const MeXScalardSetI& scalars, const MeXVec3dSetI& vectors);
  void motionCallback(size_t cellIdI,size_t cellIdJ, size_t cellIdK, const MeXScalardSetI& scalars, const MeXVec3dSetI& vectors);

private:
  virtual bool displayInstructions() const;
  virtual void getMeshAttributes(MoDrawStyle*& ds, MoMaterial*& mat, SoDrawStyle*& ids, SoPickStyle*& ps);
  virtual void insertRepresentations(SoSeparator* sep);
  virtual void insertScene2D(SoSeparator* sep);

  void setMeshAttibutes();

  TextSceneEditor* m_textEditor;

  SoPickStyle* m_ps;
  MoDrawStyle* m_ds;
  MoMaterial* m_mat;
  MoMeshPointProbe* m_probe;
  SoSwitch* m_probeSwitch;
  bool m_draggerEnabled;
};

#endif 


