#include "DemoPlaneSlice.h"

#include <Inventor/nodes/SoEventCallback.h>
#include <Inventor/nodes/SoSwitch.h>
#include <Inventor/manips/SoClipPlaneManip.h>
#include <Inventor/events/SoKeyboardEvent.h> 
#include <MeshVizXLM/mapping/nodes/MoMeshPlaneSlice.h>
#include <MeshVizXLM/mapping/nodes/MoMeshVector.h>
#include <MeshVizXLM/mapping/nodes/MoDrawStyle.h>
#include <MeshVizXLM/mapping/nodes/MoMaterial.h>

using namespace::std;

//---------------------------------------------------------------------
DemoPlaneSlice::DemoPlaneSlice() :
Demo("MeshVizXLM Skin",VOLUME_MESH_REGULAR,ALL_VOLUME_MESHES_NO_TETRA,true)
{
}

//---------------------------------------------------------------------
bool DemoPlaneSlice::displayInstructions() const
{
  cout << "Press v to toggle vector visibility" << endl;
  return true;
}

//---------------------------------------------------------------------
void DemoPlaneSlice::keyPressed(SoEventCallback *eventCB)
{
  const SoEvent *ev = eventCB->getEvent();

 if (SO_KEY_PRESS_EVENT(ev, V) )
  {
    m_vectorSwitch->whichChild = ( m_vectorSwitch->whichChild.getValue()==SO_SWITCH_ALL) ? SO_SWITCH_NONE : SO_SWITCH_ALL;
    eventCB->setHandled();
  }  
}

//---------------------------------------------------------------------
void DemoPlaneSlice::getMeshAttributes(MoDrawStyle*& ds, MoMaterial*& mat, SoDrawStyle*& /*ids*/, SoPickStyle*& ps)
{
  ps = new SoPickStyle;
  ds = m_ds = new MoDrawStyle;
  mat = m_mat = new MoMaterial;
  ps->style = SoPickStyle::UNPICKABLE;
  m_ds->displayFaces = false;
  m_ds->displayEdges = true;
  m_mat->lineColor.setValue(SbColor(0,0,0));
}

//---------------------------------------------------------------------
void DemoPlaneSlice::insertRepresentations(SoSeparator* sep)
{
  // Manipulator to move the plane slice plane (as a clip plane)
  SoClipPlaneManip *manip = new SoClipPlaneManip;
  manip->plane.setValue(SbPlane(SbVec3f(1,0,1),5.0f));
  // Turn off clip plane visibility to avoid flickering of plane slice faces.
  manip->on.setValue(FALSE); 
  manip->draggerPosition.setValue(this->getCenter());
  sep->addChild(manip);

  m_planeslice = new MoMeshPlaneSlice;
  m_planeslice->plane.connectFrom(&manip->plane);
  sep->addChild(m_planeslice);

  m_vectorSwitch = new SoSwitch;
  MoMesh* planeMesh = new MoMesh;
  planeMesh->connectFrom(m_planeslice);
  
  sep->addChild(m_vectorSwitch);
  {
    m_vectorSwitch->addChild(planeMesh);
    MoMeshVector* vector = new MoMeshVector;
    vector->scaleFactor = 0.1f;
    vector->thicknessFactor = 0.5f;
    m_vectorSwitch->addChild(vector);
  }
}


