#ifndef  _DemoPolyhedralIsosurface_h
#define  _DemoPolyhedralIsosurface_h

#include "Demo.h"
#include <PolyhedralMeshReader.h>

class MoMeshIsosurface;

class DemoPolyhedralIsosurface : public Demo
{
public:
  DemoPolyhedralIsosurface();
  ~DemoPolyhedralIsosurface();

  virtual void keyPressed(SoEventCallback *eventCB);

private:
  void setMesh(const char* filename);

  virtual const MiMesh* getInputMesh(MeshType& meshType);
  virtual const MbScalardSetI* getScalarSetI(); 

  virtual bool displayInstructions() const;
  virtual void getMeshAttributes(MoDrawStyle*& ds, MoMaterial*& mat, SoDrawStyle*& ids, SoPickStyle*& ps);
  virtual void insertRepresentations(SoSeparator* sep);

  SoSwitch*         m_isoSwitch;
  MoMeshIsosurface* m_isosurface;

  MiTessellator* m_tessellator;
  MbVolumeMeshUnstructured<>* m_mesh;

  class Transform
  {
  public:
    Transform() : reverse(false) {}
    MbVec3d operator()(const MbVec3d& coord) const;
    bool reverse;
  };
  Transform m_transformFunc;

  double m_isoMidValue;
  
  std::string m_demoPath;
  std::string m_meshFileName;
  PolyhedralMeshReader m_reader;

};

#endif 


