#include "DemoProbing.h"

#include <Inventor/nodes/SoPickStyle.h>
#include <Inventor/draggers/SoJackDragger.h>
#include <MeshVizXLM/mapping/nodes/MoDrawStyle.h>
#include <MeshVizXLM/mapping/nodes/MoMaterial.h>

using namespace::std;

//---------------------------------------------------------------------
DemoProbing::DemoProbing() : Demo("MeshVizXLM Probing",VOLUME_MESH_UNSTRUCTURED) 
{
}

//---------------------------------------------------------------------
DemoProbing::~DemoProbing()
{
  delete m_textEditor;
}

//---------------------------------------------------------------------
bool DemoProbing::displayInstructions() const
{
  cout << "Move the dragger inside the mesh." << endl << endl;
  return false;
}

//---------------------------------------------------------------------
void DemoProbing::insertRepresentations(SoSeparator* sep)
{
  // Dragger used to move the position of the probe 
  SoJackDragger* dragger = new SoJackDragger;
  dragger->translation = this->getCenter();
  sep->addChild(dragger);

  MoMeshPointProbe* probe = new MoMeshPointProbe;
  // callback called each time position changes 
  probe->setProbeCallback(*this);
  // attach the position of the probe to the position of the dragger
  probe->position.connectFrom(&dragger->translation);
  sep->addChild(probe);
}

//---------------------------------------------------------------------
// callback called each time the field position of the probe changes
void DemoProbing::motionCallback(size_t cellId, const MeXScalardSetI& scalars, const MeXVec3dSetI& vectors)
{
  // scalars or vectors may contain several values when multiple dataset are set.
  // here we use only the first one.
  double scalar = scalars.getSize() > 0 ? scalars.get(0) : 0;
  MbVec3d vector = vectors.getSize() > 0 ? vectors.get(0) : MbVec3d(0);
  m_textEditor->edit(cellId,scalar,vector);
}

//---------------------------------------------------------------------
void DemoProbing::getMeshAttributes(MoDrawStyle*& ds, MoMaterial*& mat, SoDrawStyle*& /*ids*/, SoPickStyle*& ps)
{
  ps = new SoPickStyle;
  ds = new MoDrawStyle;
  mat = new MoMaterial;
  ds->displayFaces = false;
  ds->displayEdges = true;
  mat->lineColor.setValue(SbColor(0,0,0));
  mat->lineColoring = MoMaterial::CONTOURING;
  ps->style = SoPickStyle::UNPICKABLE;
}

//---------------------------------------------------------------------
void DemoProbing::insertScene2D(SoSeparator* sep)
{
  m_textEditor = new TextSceneEditor(sep);
}

