#ifndef  _Dataset_h
#define  _Dataset_h

#include <MeshVizXLM/mesh/MiVolumeMeshUnstructured.h>
#include <MeshVizXLM/mesh/data/MiDataSetI.h>

#include <Inventor/STL/vector>
#include <Inventor/STL/cassert>

//-----------------------------------------------------------------------------
template<typename _F>
class Dataset : public MiScalardSetI
{
public:
  Dataset(const MiVolumeMeshUnstructured& mesh);

  double get(size_t i) const 
  { 
    return m_values[i];
  }

  double getMin () const { return m_vmin; }
  double getMax () const { return m_vmax; }
  size_t  getTimeStamp () const  { return 1; }
  std::string getName () const  { return m_function.getName(); }
  DataBinding  getBinding () const { return PER_NODE; }

private:
  std::vector<double> m_values;
  double m_vmin,m_vmax;
  _F m_function;
};


//-----------------------------------------------------------------------------
template<typename _F>
Dataset<_F>::Dataset(const MiVolumeMeshUnstructured& mesh)
{
  size_t numNodes = mesh.getTopology().getEndNodeId();
  const MiGeometryI& geometry = mesh.getGeometry();
  m_values.reserve(numNodes);
  m_vmin = 1E30;
  m_vmax = -1E30;
  for (size_t i=mesh.getTopology().getBeginNodeId(); i!=mesh.getTopology().getEndNodeId(); ++i)
  {
    double v = m_function(geometry.getCoord(i));
    if (v < m_vmin) m_vmin = v;
    if (v > m_vmax) m_vmax = v;
    m_values.push_back(v);
  }
}



#endif 


