#ifndef  _Geometry_h
#define  _Geometry_h

#include <MeshVizXLM/mesh/geometry/MiGeometryI.h>

#include <Inventor/SbBox.h>

#include <Inventor/STL/vector>

static const int NUM_COORDS=27;

//-----------------------------------------------------------------------------
class Geometry : public MiGeometryI
{
public:

  Geometry()
  {
    MbVec3d coords[NUM_COORDS] = 
    {
      MbVec3d( 0.0, 0.0, 0.0 ),    // 0
      MbVec3d( 2.0, 0.0, 0.0 ),    // 1
      MbVec3d( 2.0, 2.0, 0.0 ),    // 2
      MbVec3d( 0.0, 2.0, 0.0 ),    // 3
      MbVec3d( 0.0, 0.0, 2.0 ),    // 4
      MbVec3d( 2.0, 0.0, 2.0 ),    // 5
      MbVec3d( 2.0, 2.0, 2.0 ),    // 6
      MbVec3d( 0.0, 2.0, 2.0 ),    // 7

      MbVec3d( 1.0,-0.1,-0.2 ),    // 8
      MbVec3d( 1.9, 1.0, 0.0 ),    // 9
      MbVec3d( 1.0, 2.0,-0.2 ),    // 10
      MbVec3d( 0.2, 1.0, 0.0 ),    // 11
      MbVec3d( 1.0,-0.1, 2.2 ),    // 12
      MbVec3d( 2.2, 1.0, 2.0 ),    // 13
      MbVec3d( 1.0, 2.0, 2.2 ),    // 14
      MbVec3d(-0.2, 1.0, 2.0 ),    // 15

      MbVec3d( 0.2, 0.0, 1.0 ),    // 16
      MbVec3d( 1.9, 0.0, 1.0 ),    // 17
      MbVec3d( 2.0, 2.2, 1.0 ),    // 18
      MbVec3d( 0.0, 2.2, 1.0 ),    // 19

      MbVec3d( 1.0, 1.0, 0.0 ),    // 20
      MbVec3d( 2.0, 1.0, 1.0 ),    // 21
      MbVec3d( 1.0, 1.0, 2.0 ),    // 22
      MbVec3d( 0.0, 1.0, 1.0 ),    // 23

      MbVec3d( 1.0, 0.0, 1.0 ),    // 24
      MbVec3d( 1.0, 2.0, 1.0 ),    // 25
      MbVec3d( 1.0, 1.0, 1.0 )     // 26
    };
    m_coords.assign(coords,coords+NUM_COORDS);

    SbBox3d bbox;
    for (size_t i=0; i<NUM_COORDS; ++i)
      bbox.extendBy((SbVec3d)m_coords[i]);
    m_coordMin = (MbVec3d)bbox.getMin();
    m_coordMax = (MbVec3d)bbox.getMax();
  }


  virtual MbVec3d getCoord(size_t i) const 
  {
    return m_coords[i];
  }

  virtual MbVec3d getMin() const 
  {
    return m_coordMin;
  }
  /**
  * Returns the maximum value of this set.
  */
  virtual MbVec3d getMax() const 
  {
    return m_coordMax;
  }


  virtual size_t getTimeStamp() const 
  {
    return 1;
  }

private:
  std::vector<MbVec3d> m_coords;
  MbVec3d m_coordMin;
  MbVec3d m_coordMax;

};


#endif 


