#include <MeshVizXLM/mapping/MoMeshViz.h>
#include <MeshVizXLM/mapping/nodes/MoMesh.h>
#include <MeshVizXLM/mapping/nodes/MoScalarSetI.h>
#include <MeshVizXLM/mapping/nodes/MoPredefinedColorMapping.h>
#include <MeshVizXLM/mapping/nodes/MoMeshLine.h>
#include <MeshVizXLM/mapping/nodes/MoMeshCellShape.h>
#include <MeshVizXLM/mapping/nodes/MoDrawStyle.h>
#include <MeshVizXLM/mapping/nodes/MoMaterial.h>
#include <MeshVizXLM/mapping/nodes/MoTessellator.h>

#include <MeshVizXLM/tessellator/MiTessellator.h>
#include <MeshVizXLM/tessellator/MxEdgeErrorMetricGeometry.h>
#include <MeshVizXLM/extractors/MiExtractorCallback.h>


#include <mesh/lines/QuadraticLineMesh.h>


#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoDrawStyle.h>


#include <Inventor/STL/iostream>
#include <Inventor/STL/vector>
using namespace std;

#define NAMESTR "MeshVizXLM displaying a tesselated line mesh from a quadratic mesh"

#ifdef _MSC_VER
#pragma warning( push )
#pragma warning(disable:4250)
#endif


class ExtractorCallback : public MiExtractorCallback
{
public:
  void beginExtract(const std::string name, bool geomChanged, bool topoChanged, bool dataSetChanged, size_t) 
  {
    if(topoChanged || geomChanged)
      std::cout << name <<" starts extraction." << std::endl;
    if(dataSetChanged)
      std::cout << name <<" starts dataset extraction." << std::endl;
  }
  void endExtract()
  {
    std::cout << "extraction finished" << std::endl;
  }
  bool beginPhase(size_t , std::string , size_t ) { return true; }
  bool endPhase() { return true; }
  bool endStep(size_t ) { return true; }
  double getEndStepCallPeriod() { return 1.0; }
};

//-----------------------------------------------------------------------------
int
main(int, char **)
{

 QuadraticLineMesh quadraticMesh;

  // Init viewer
  Widget my_window = SoXt::init(NAMESTR) ;
  if (my_window == NULL) exit(1) ;

  MoMeshViz::init();


  // Build a sample surface mesh
  
  // ======== linear representation of the quadratic line (use a basic tesselator) ==========
  MiTessellator* basicTessellator = MiTessellator::getNewTessellatorBasic();

  MoMesh* meshNode = new MoMesh;
  meshNode->setMesh(&quadraticMesh); 

  MoTessellator* basicTessellatorNode = new MoTessellator;
  basicTessellatorNode->setTessellator(basicTessellator);

  SoMaterial* basicMaterial = new SoMaterial;
  basicMaterial->diffuseColor = SbColor(1,0,0);

  // ======== tessellated representation of the quadratic line (use a fine tesselator) ==========
  MxEdgeErrorMetricGeometry edgeErrorMetricGeometry(0.02);
  MiTessellator* tessellator = MiTessellator::getNewTessellatorGeometry(edgeErrorMetricGeometry);

  MoTessellator* tessellatorNode = new MoTessellator;
  tessellatorNode->setTessellator(tessellator);

  SoMaterial* tessellatedMaterial = new SoMaterial;
  tessellatedMaterial->diffuseColor = SbColor(1,1,1);

  MoDrawStyle* ds = new MoDrawStyle;
  ds->displayEdges = true;
  ds->displayPoints = true;

  SoDrawStyle* pds = new SoDrawStyle;
  pds->pointSize = 5.f;
  SoDrawStyle* cds = new SoDrawStyle;
  cds->pointSize = 5.f;
  cds->lineWidth = 2.f;

  MoMaterial* mat = new MoMaterial;
  mat->lineColor = SbColor(0,1,0);
  mat->pointColor = SbColor(0,1,0);

  MoMeshCellShape* cellShape = new MoMeshCellShape;
  cellShape->cellIndices.setValue(1);

  // Display the line mesh
  ExtractorCallback cb;
  MoMeshLine *line1 = new MoMeshLine;
  line1->setExtractorCallback(&cb);
  MoMeshLine *line2 = new MoMeshLine;
  line2->setExtractorCallback(&cb);

  SoSeparator* sep = new SoSeparator;
  {
    sep->addChild(meshNode);

    //sep->addChild(colorMap);
    sep->addChild(basicMaterial);
    sep->addChild(basicTessellatorNode);
    sep->addChild(line1);

    sep->addChild(pds);
    sep->addChild(ds);
    sep->addChild(tessellatedMaterial);
    sep->addChild(tessellatorNode);
    sep->addChild(line2);
    sep->addChild(cds);
    sep->addChild(mat);
    sep->addChild(cellShape);
  }

  SoXtExaminerViewer* viewer = new SoXtExaminerViewer(my_window);
  viewer->setSceneGraph(sep);
  viewer->setSize(SbVec2s(1024,768));
  viewer->show();
  viewer->viewAll();

  // dialog
  SoXt::show(my_window);
  SoXt::mainLoop();

  delete viewer;
  MoMeshViz::finish();
  SoXt::finish();

  return 0;
}

#ifdef _MSC_VER
#pragma warning( pop ) 
#endif

