#ifndef  _Demo_QuadraticSkin_h
#define  _Demo_QuadraticSkin_h

class SoNode;
class SoSwitch;
class SoEventCallback;
class MoMesh;
class MiTessellator;
class MoScalarSetI;
class MoTessellator;

#include <Inventor/SbElapsedTime.h>
#include <MeshVizXLM/mesh/MiVolumeMeshUnstructured.h>
#include <MeshVizXLM/tessellator/MxEdgeErrorMetricGeometry.h>
#include <data/MbScalarSetI.h>
#include "QuadraticMesh.h"

#define NAMESTR "MeshVizXLM sample program showing how to display quadratic cells"

class Demo_QuadraticSkin
{
public:
  Demo_QuadraticSkin();
  int run(const MiVolumeMeshUnstructured& mesh, const MbScalardSetI& dataset);

  void keyPressed(SoEventCallback *eventCB);

private:
  SoNode* buildSceneGraph(const MiVolumeMeshUnstructured& mesh, const MbScalardSetI& dataset);
  void updateTessellation(double metricError);

  void keyPressedT();
  void keyPressedD();
  void keyPressedI();
  void keyPressedP();
  void keyPressedM();

  double m_width;
  QuadraticMesh m_mesh;
  ScalarSet     m_dataset;

  SbElapsedTime localTime;
  double m_maxError;
  double m_minError;
  double m_incrError;
  double m_metricError;

  MxEdgeErrorMetricGeometry m_edgeErrorMetricGeometry;
  MiTessellator* m_tessellator;
  MoScalarSetI* m_tessellatedScalarSetNode;

  SoSwitch* m_basicSwitch;
  SoSwitch* m_tessellatedSwitch;
  MoMesh* m_tessellatedMeshNode;
  MoTessellator* m_geometryTessellatorNode;

};

#endif 


