#ifndef  _QuadraticHexahedronCell_h
#define  _QuadraticHexahedronCell_h

#include <MeshVizXLM/extractors/MxHexahedron20CellExtract.h>
#include <MeshVizXLM/mesh/cell/MiVolumeCell.h>

#include <Inventor/STL/vector>

//-----------------------------------------------------------------------------
class QuadraticHexahedronCell : public MiVolumeCell
{
public:
  QuadraticHexahedronCell(
    size_t nodeId0, size_t nodeId1, size_t nodeId2, size_t nodeId3, 
    size_t nodeId4, size_t nodeId5, size_t nodeId6, size_t nodeId7, 
    size_t nodeId8, size_t nodeId9, size_t nodeId10,size_t nodeId11,
    size_t nodeId12,size_t nodeId13,size_t nodeId14,size_t nodeId15,
    size_t nodeId16,size_t nodeId17,size_t nodeId18,size_t nodeId19)
  {
    m_nodeIds[0] = nodeId0;
    m_nodeIds[1] = nodeId1;
    m_nodeIds[2] = nodeId2;
    m_nodeIds[3] = nodeId3;
    m_nodeIds[4] = nodeId4;
    m_nodeIds[5] = nodeId5;
    m_nodeIds[6] = nodeId6;
    m_nodeIds[7] = nodeId7;
    m_nodeIds[8] = nodeId8;
    m_nodeIds[9] = nodeId9;
    m_nodeIds[10] = nodeId10;
    m_nodeIds[11] = nodeId11;
    m_nodeIds[12] = nodeId12;
    m_nodeIds[13] = nodeId13;
    m_nodeIds[14] = nodeId14;
    m_nodeIds[15] = nodeId15;
    m_nodeIds[16] = nodeId16;
    m_nodeIds[17] = nodeId17;
    m_nodeIds[18] = nodeId18;
    m_nodeIds[19] = nodeId19;
  }

  virtual size_t getNumEdges() const 
  {
    return 12;
  }

  virtual size_t getNumNodes() const 
  {
    return 20;
  }

  virtual size_t getNumFacets() const   {
    return 6;
  }

  /**
  * Gets the index (in the mesh) of a node
  * @param[in] node Node number (where: 0<= node < getNumNodes()).
  */
  virtual size_t getNodeIndex(size_t node) const 
  {
    return m_nodeIds[node];
  }

  virtual void getIsosurfTopology(unsigned char /*caseId*/, std::vector< std::pair<size_t,size_t> >& /*edgeList*/ ) const 
  {
    throw;
  }

  virtual size_t appendNodesIndexOfFacet (size_t facet, std::vector<size_t>& facetNodes) const
  {
    facetNodes.push_back(m_nodeIds[s_facetNode[facet][0]]);
    facetNodes.push_back(m_nodeIds[s_facetNode[facet][1]]);
    facetNodes.push_back(m_nodeIds[s_facetNode[facet][2]]);
    facetNodes.push_back(m_nodeIds[s_facetNode[facet][3]]);
    return 4;
  }

  virtual MbVec3d getIsoParametricCoord(size_t nodeIndex) const 
  {
    return MxHexahedron20CellExtract::getIsoParametricCoord(nodeIndex);
  }

  //Reimplemented from MiCell 
  virtual void getWeight(const MbVec3d &ipcoord, std::vector<double>& weight) const
  {
    return MxHexahedron20CellExtract::getWeight(ipcoord,weight);
  }

  virtual size_t getSubTriangleNodesIndex(size_t facet, std::vector<size_t>& triangleNodeIds) const 
  {
    return MxHexahedron20CellExtract::getSubTriangleNodesIndex(facet,triangleNodeIds);
  }

protected:
  size_t m_nodeIds[20];
  static size_t s_facetNode[6][4];
};

#endif 


