#ifndef  _DemoQuadraticSurface_h
#define  _DemoQuadraticSurface_h

#include "Demo.h"
#include <mesh/surfaces/QuadraticSurfaceMesh.h>

#include <MeshVizXLM/tessellator/MxEdgeErrorMetricGeometry.h>

class SoSwitch;
class MoMeshCellShape;
class MiTessellator;

class DemoQuadraticSurface : public Demo
{
public:
  DemoQuadraticSurface();
  ~DemoQuadraticSurface();

  virtual void keyPressed(SoEventCallback *eventCB);
  virtual void mouseMoved(SoEventCallback *eventCB);

private:
  virtual const MiMesh* getInputMesh(MeshType& meshType);
  virtual       MiTessellator* getTessellator();
  virtual const MbScalardSetI* getScalarSetI(); 

  virtual bool displayInstructions() const;
  virtual void getMeshAttributes(MoDrawStyle*& ds, MoMaterial*& mat, SoDrawStyle*& ids, SoPickStyle*& ps);
  virtual MiExtractorCallback* getExtractorCallback();
  virtual void insertRepresentations(SoSeparator* sep);

  void updateTessellation(double metricError);

  void keyPressedT();
  void keyPressedP();
  void keyPressedE();
  void keyPressedF();
  void keyPressedO();
  void keyPressedD();
  void keyPressedI();
  void keyPressedC();

  QuadraticSurfaceMesh m_mesh;
  ScalarSet     m_dataset;

  double m_maxError;
  double m_minError;
  double m_incrError;
  double m_metricError;

  bool m_enableTessellation;
  MiTessellator* m_basicTessellator;
  MiTessellator* m_geometryTessellator;
  MxEdgeErrorMetricGeometry m_edgeErrorMetricGeometry;

  MoMeshCellShape* m_cellShape;

  SoSwitch* m_outlineSwitch;
  SoSwitch* m_cliplineSwitch;

  //SoPickStyle* m_ps;
  MoDrawStyle* m_ds;
  MoMaterial* m_mat;
};

#endif 


