#include "Demo.h"

#include <MeshVizXLM/mapping/MoMeshViz.h>

#include "QuadraticMesh.h"
#include "../MeshViewer/MeshViewer.h"

#include <Inventor/STL/vector>

//---------------------------------------------------------------------
Demo::Demo() :
s_volumeScalarSet(s_volumeMesh)
{
}

//-----------------------------------------------------------------------------
int
Demo::run()
{

  std::vector<const MiScalardSetI*> dss(1,&s_volumeScalarSet);
  std::vector<const MiVec3dSetI*> dsv;

  MxEdgeErrorMetricGeometry metric(0.02);
  MiTessellator* tessellator = MiTessellator::getNewTessellatorGeometry(metric);
  MeshViewer mesh_viewer;
  mesh_viewer.setCourtesyTitle("Generic mesh of 4 quadratic hexahedron of 20 nodes");
  mesh_viewer.show(s_volumeMesh,dss,dsv,tessellator,&metric);

  delete tessellator;

  return 0;

}


