#ifndef  _LinearQuadrangleCell_h
#define  _LinearQuadrangleCell_h

#include <MeshVizXLM/mesh/cell/MiSurfaceCell.h>

//-----------------------------------------------------------------------------
class LinearQuadrangleCell : public MiSurfaceCell
{
public:
  LinearQuadrangleCell(size_t nodeId0, size_t nodeId1, size_t nodeId2, size_t nodeId3) 
  {
    m_nodeIds[0] = nodeId0;
    m_nodeIds[1] = nodeId1;
    m_nodeIds[2] = nodeId2;
    m_nodeIds[3] = nodeId3;
  }

  virtual size_t getNumEdges() const 
  {
    return 4;
  }

  virtual size_t getNumNodes() const 
  {
    return 4;
  }

  /**
  * Gets the index (in the mesh) of a node
  * @param[in] node Node number (where: 0<= node < getNumNodes()).
  */
  virtual size_t getNodeIndex(size_t node) const 
  {
    return m_nodeIds[node];
  }

  //virtual MbVec3d getIsoParametricCoord(size_t nodeIndex) const 
  //{
  //  switch (nodeIndex)
  //  {
  //  case 0: return MbVec3d(0,0,0);
  //  case 1: return MbVec3d(1,0,0);
  //  case 2: return MbVec3d(1,1,0);
  //  case 3: return MbVec3d(0,1,0);
  //  }
  //}

protected:
  size_t m_nodeIds[4];


};

#endif 


