#include "QuadraticMesh.h"

using std::vector;

static double s_width = 2;

//---------------------------------------------------------------------------------------------------------------------
QuadraticGeometry::QuadraticGeometry()
{
  m_coords.assign(48,MbVec3d(0,0,0));

  vector<MbVec3d> face8Coord0 = computeQuadraticFace8(0, s_radiusMin,s_radiusMax, s_width);
  vector<MbVec3d> face8CoordPi = computeQuadraticFace8(3.14159/2, s_radiusMin,s_radiusMax, s_width);
  vector<MbVec3d> face4CoordPi = computeQuadraticFace4(3.14159/4, s_radiusMin,s_radiusMax, s_width);

  m_coords[0] = face8Coord0[0];
  m_coords[1] = face8Coord0[1];
  m_coords[2] = face8Coord0[2];
  m_coords[3] = face8Coord0[3];
  
  m_coords[4] = face8CoordPi[0];
  m_coords[5] = face8CoordPi[1];
  m_coords[6] = face8CoordPi[2];
  m_coords[7] = face8CoordPi[3];

  m_coords[8] = face8Coord0[4];
  m_coords[9] = face8Coord0[5];
  m_coords[10] = face8Coord0[6];
  m_coords[11] = face8Coord0[7];

  m_coords[12] = face8CoordPi[4];
  m_coords[13] = face8CoordPi[5];
  m_coords[14] = face8CoordPi[6];
  m_coords[15] = face8CoordPi[7];

  m_coords[16] = face4CoordPi[0];
  m_coords[17] = face4CoordPi[1];
  m_coords[18] = face4CoordPi[2];
  m_coords[19] = face4CoordPi[3];

  for (int i=0; i<20; ++i)
    m_coords[i] = getCartCoord(m_coords[i]);

  // add symetric points
  m_coords[20] = getSymetricToXPlane(0) ;
  m_coords[21] = getSymetricToXPlane(1) ; 
  m_coords[22] = getSymetricToXPlane(2) ; 
  m_coords[23] = getSymetricToXPlane(3) ; 

  m_coords[24] = getSymetricToXPlane(8) ; 
  m_coords[25] = getSymetricToXPlane(9) ; 
  m_coords[26] = getSymetricToXPlane(10); 
  m_coords[27] = getSymetricToXPlane(11);

  m_coords[28] = getSymetricToXPlane(16); 
  m_coords[29] = getSymetricToXPlane(17); 
  m_coords[30] = getSymetricToXPlane(18); 
  m_coords[31] = getSymetricToXPlane(19);

  m_coords[32] = getSymetricToYPlane(4);
  m_coords[33] = getSymetricToYPlane(5); 
  m_coords[34] = getSymetricToYPlane(6); 
  m_coords[35] = getSymetricToYPlane(7); 

  m_coords[36] = getSymetricToYPlane(12);
  m_coords[37] = getSymetricToYPlane(13); 
  m_coords[38] = getSymetricToYPlane(14); 
  m_coords[39] = getSymetricToYPlane(15); 

  m_coords[40] = getSymetricToYPlane(28);
  m_coords[41] = getSymetricToYPlane(29); 
  m_coords[42] = getSymetricToYPlane(30); 
  m_coords[43] = getSymetricToYPlane(31); 

  m_coords[44] = getSymetricToYPlane(16);
  m_coords[45] = getSymetricToYPlane(17); 
  m_coords[46] = getSymetricToYPlane(18); 
  m_coords[47] = getSymetricToYPlane(19); 

  m_bbox.makeEmpty();
  for (size_t i=0; i<48; ++i)
    m_bbox.extendBy((SbVec3d)m_coords[i]);
}



//---------------------------------------------------------------------------------------------------------------------
std::vector<MbVec3d> 
QuadraticGeometry::computeQuadraticFace8(double alpha, double rmin, double rmax, double width) const
{
  std::vector<MbVec3d> coords(computeQuadraticFace4(alpha,rmin,rmax,width));

  coords.push_back(MbVec3d((rmin+rmax)/2, alpha, -width * 1.25));
  coords.push_back(MbVec3d(rmax*1.1, alpha, 0));
  coords.push_back(MbVec3d((rmin+rmax)/2, alpha, +width * 1.25));
  coords.push_back(MbVec3d(rmin*1.05, alpha, 0));

  return coords;
};

//---------------------------------------------------------------------------------------------------------------------
std::vector<MbVec3d> 
QuadraticGeometry::computeQuadraticFace4(double alpha, double rmin, double rmax, double width) const
{
  std::vector<MbVec3d> coords;
  coords.push_back(MbVec3d(rmin, alpha, -width));
  coords.push_back(MbVec3d(rmax, alpha, -width));
  coords.push_back(MbVec3d(rmax, alpha, +width));
  coords.push_back(MbVec3d(rmin, alpha, +width));

  return coords;
};

