#include "Demo.h"

#include <MeshVizXLM/mapping/MoMeshViz.h>

#include "../MeshViewer/MeshViewer.h"

#include <Inventor/STL/vector>

//-----------------------------------------------------------------------------
// List of functions used to define a several dataset
// Each function depends on the form f = f(x,y,z) 

class DistanceToXAxis
{
public:
  double operator()(const MbVec3d& coord) { return sqrt(coord[1]*coord[1] + coord[2]*coord[2]); }
  std::string getName() const { return "Distance to X axis"; }
};


class DistanceToYAxis
{
public:
  double operator()(const MbVec3d& coord) { return sqrt(coord[0]*coord[0] + coord[2]*coord[2]); }
  std::string getName() const { return "Distance to Y axis"; }
};

class DistanceToZAxis
{
public:
  double operator()(const MbVec3d& coord) { return sqrt(coord[0]*coord[0] + coord[1]*coord[1]); }
  std::string getName() const { return "Distance to Z axis"; }
};

class DistanceToOrigin
{
public:
  double operator()(const MbVec3d& coord) { return sqrt(coord[0]*coord[0] + coord[1]*coord[1] + coord[2]*coord[2]); }
  std::string getName() const { return "Distance to origin"; }
};

class Fx
{
public:
  double operator()(const MbVec3d& coord) { return coord[0]; }
  std::string getName() const { return "X"; }
};

class Fy
{
public:
  double operator()(const MbVec3d& coord) { return coord[1]; }
  std::string getName() const { return "Y"; }
};

class Fz
{
public:
  double operator()(const MbVec3d& coord) { return coord[2]; }
  std::string getName() const { return "Z"; }
};


//-----------------------------------------------------------------------------
int
Demo::run()
{
  Mesh mesh;

  std::vector<const MiScalardSetI*> dss;
  std::vector<const MiVec3dSetI*> dsv;

  dss.push_back(new Dataset<DistanceToXAxis>(mesh));
  dss.push_back(new Dataset<DistanceToYAxis>(mesh));
  dss.push_back(new Dataset<DistanceToZAxis>(mesh));
  dss.push_back(new Dataset<DistanceToOrigin>(mesh));
  dss.push_back(new Dataset<Fx>(mesh));
  dss.push_back(new Dataset<Fy>(mesh));
  dss.push_back(new Dataset<Fz>(mesh));

  MxEdgeErrorMetricGeometry metric(0.02);
  MiTessellator* tessellator = MiTessellator::getNewTessellatorGeometry(metric);
  MeshViewer mesh_viewer;
  mesh_viewer.setCourtesyTitle("Quadratic wedge with 18 nodes");
  mesh_viewer.show(mesh,dss,dsv,tessellator,&metric);

  delete tessellator;

  return 0;
}


