#ifndef  _Geometry_h
#define  _Geometry_h

#include <MeshVizXLM/mesh/geometry/MiGeometryI.h>

#include <Inventor/SbBox.h>

#include <Inventor/STL/vector>

static const int NUM_COORDS=18;
//-----------------------------------------------------------------------------
class Geometry : public MiGeometryI
{
public:

  Geometry()
  {
    MbVec3d coords[NUM_COORDS] = 
    {
      MbVec3d( 0.0, 0.0, 0.0 ),    // 0
      MbVec3d( 2.0, 0.0, 0.0 ),    // 1
      MbVec3d( 0.0, 2.0, 0.0 ),    // 2
      MbVec3d( 0.0, 0.0, 2.0 ),    // 3
      MbVec3d( 2.0, 0.0, 2.0 ),    // 4
      MbVec3d( 0.0, 2.0, 2.0 ),    // 5
      MbVec3d( 1.0, 0.1, 0.0 ),    // 6
      MbVec3d( 1.3, 1.1,-0.1 ),    // 7
      MbVec3d(-0.1, 1.0,-0.1 ),    // 8
      MbVec3d( 1.0, 0.1, 2.0 ),    // 9
      MbVec3d( 1.3, 1.1, 1.9 ),    // 10
      MbVec3d(-0.1, 1.0, 1.9 ),    // 11
      MbVec3d( 0.0, 0.1, 1.0 ),    // 12
      MbVec3d( 2.0, 0.1, 1.0 ),    // 13
      MbVec3d( 0.0, 2.1, 1.0 ),    // 14
      MbVec3d( 1.0, 0.1, 1.0 ),    // 15
      MbVec3d( 1.3, 1.1, 1.0 ),    // 16
      MbVec3d(-0.1, 1.1, 1.0 )     // 17
    };
    m_coords.assign(coords,coords+NUM_COORDS);

    SbBox3d bbox;
    for (size_t i=0; i<NUM_COORDS; ++i)
      bbox.extendBy((SbVec3d)m_coords[i]);
    m_coordMin = (MbVec3d)bbox.getMin();
    m_coordMax = (MbVec3d)bbox.getMax();
  }


  virtual MbVec3d getCoord(size_t i) const 
  {
    return m_coords[i];
  }

  virtual MbVec3d getMin() const 
  {
    return m_coordMin;
  }
  /**
  * Returns the maximum value of this set.
  */
  virtual MbVec3d getMax() const 
  {
    return m_coordMax;
  }


  virtual size_t getTimeStamp() const 
  {
    return 1;
  }

private:
  std::vector<MbVec3d> m_coords;
  MbVec3d m_coordMin;
  MbVec3d m_coordMax;

};


#endif 


