#ifndef  _Wedge18Cell_h
#define  _Wedge18Cell_h

#include <MeshVizXLM/extractors/MxWedge18CellExtract.h>
#include <MeshVizXLM/mesh/cell/MiVolumeCell.h>

#include <Inventor/STL/vector>

//-----------------------------------------------------------------------------
class Wedge18Cell : public MiVolumeCell
{
public:
  Wedge18Cell() 
  {
    size_t nodeIds[18] = 
    {
      0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17
    };
    s_nodeIds.assign(nodeIds,nodeIds+18);
  }

  virtual size_t getNumEdges() const 
  {
    return 9;
  }

  virtual size_t getNumNodes() const 
  {
    return 18;
  }

  virtual size_t getNumFacets() const   {
    return 5;
  }

  virtual size_t getNodeIndex(size_t node) const 
  {
    return s_nodeIds[node];
  }

  virtual void getIsosurfTopology(unsigned char /*caseId*/, std::vector< std::pair<size_t,size_t> >& /*edgeList*/ ) const 
  {
  }

  virtual size_t appendNodesIndexOfFacet (size_t facet, std::vector<size_t>& facetNodes) const;

  virtual MbVec3d getIsoParametricCoord(size_t nodeIndex) const 
  {
    return MxWedge18CellExtract::getIsoParametricCoord(nodeIndex);
  }

  //Reimplemented from MiCell 
  virtual void getWeight(const MbVec3d &ipcoord, std::vector<double>& weight) const
  {
    return MxWedge18CellExtract::getWeight(ipcoord,weight);
  }

  virtual size_t getSubTriangleNodesIndex(size_t facet, std::vector<size_t>& triangleNodeIds) const 
  {
    return MxWedge18CellExtract::getSubTriangleNodesIndex(facet,triangleNodeIds);
  }

  virtual size_t getSubTetrahedronNodesIndex (std::vector<size_t>& tetrahedronNodeIds) const 
  {
    return MxWedge18CellExtract::getSubTetrahedronNodesIndex(tetrahedronNodeIds);
  }

  virtual bool isPointInsideCell(const MiGeometryI& meshGeometry, const MbVec3d &point, std::vector<double>& weights) const
  {
    return MxWedge18CellExtract::isPointInsideCell(meshGeometry,this,point,weights);
  }


protected:
  std::vector<size_t> s_nodeIds;
};


inline size_t 
Wedge18Cell::appendNodesIndexOfFacet (size_t facet, std::vector<size_t>& facetNodes) const
{
  std::vector<size_t> localFacetNode;
  MxWedge18CellExtract::getNodesIndexOfFacet(facet,localFacetNode);
  for (size_t i=0; i<localFacetNode.size(); ++i)
    facetNodes.push_back(s_nodeIds[localFacetNode[i]]);
  return localFacetNode.size();
}

#endif 


