#include "WheelGeometry.h"

using std::vector;

//---------------------------------------------------------------------------------------------------------------------
WheelGeometry::WheelGeometry(size_t numCellR, size_t numCellA, size_t numCellB)
{
  m_numNodeR = 2*numCellR + 1;
  m_numNodeA = 2*numCellA + 1;
  m_numNodeB = 2*numCellB + 1;
  m_coords.reserve( m_numNodeR * m_numNodeA * m_numNodeB );
}

//---------------------------------------------------------------------------------------------------------------------
void
WheelGeometry::setGeometry(double rmin, double rmax, double alphamin, double alphamax, double zmin, double zmax)
{
  size_t i,j,k;

  double dr = (rmax-rmin)/(m_numNodeR-1);
  double da = (alphamax-alphamin)/(m_numNodeA-1);
  double dz = (zmax-zmin)/(m_numNodeB-1);

  double rcoord = rmin;
  double acoord = alphamin;
  double zcoord = zmin;

  m_coords.clear();
  m_bbox.makeEmpty();

  for (k=0; k<m_numNodeB; ++k)
  {
    acoord = alphamin;
    for (j=0; j<m_numNodeA; ++j)
    {
      rcoord = rmin;
      for (i=0; i<m_numNodeR; ++i)
      {
        MbVec3d point = getCartesianCoord(rcoord,acoord,zcoord);
        m_coords.push_back(point);
        m_bbox.extendBy(SbVec3d(point));
        rcoord += dr;
      }
      acoord += da;
    }
    zcoord += dz;
  }
}

