#ifndef  _WheelHexahedron20Cell_h
#define  _WheelHexahedron20Cell_h

#include <MeshVizXLM/extractors/MxHexahedron20CellExtract.h>
#include <MeshVizXLM/extractors/MxHexahedronCellExtract.h>
#include <MeshVizXLM/mesh/cell/MiVolumeCell.h>

#include <Inventor/STL/vector>

//-----------------------------------------------------------------------------
class WheelHexahedron20Cell : public MiVolumeCell
{
public:
  WheelHexahedron20Cell(size_t nodeId[20])
  {
    for (size_t i=0; i<20; ++i)
      m_nodeIds[i] = nodeId[i];
  }

  virtual size_t getNumEdges() const 
  {
    return 12;
  }

  virtual size_t getNumNodes() const 
  {
    return 20;
  }

  virtual size_t getNumFacets() const   {
    return 6;
  }

  /**
  * Gets the index (in the mesh) of a node
  * @param[in] node Node number (where: 0<= node < getNumNodes()).
  */
  virtual size_t getNodeIndex(size_t node) const 
  {
    return m_nodeIds[node];
  }

  virtual void getIsosurfTopology(unsigned char caseId, std::vector< std::pair<size_t,size_t> >& edgeList ) const 
  {
    return MxHexahedronCellExtract::getIsosurfTopology(caseId,edgeList);
  }

  virtual size_t appendNodesIndexOfFacet (size_t facet, std::vector<size_t>& facetNodes) const;

  virtual MbVec3d getIsoParametricCoord(size_t nodeIndex) const 
  {
    return MxHexahedron20CellExtract::getIsoParametricCoord(nodeIndex);
  }

  //Reimplemented from MiCell 
  virtual void getWeight(const MbVec3d &ipcoord, std::vector<double>& weight) const
  {
    return MxHexahedron20CellExtract::getWeight(ipcoord,weight);
  }

  virtual size_t getSubTriangleNodesIndex(size_t facet, std::vector<size_t>& triangleNodeIds) const 
  {
    return MxHexahedron20CellExtract::getSubTriangleNodesIndex(facet,triangleNodeIds);
  }

  virtual size_t getSubTetrahedronNodesIndex (std::vector<size_t>& tetrahedronNodeIds) const 
  {
    return MxHexahedron20CellExtract::getSubTetrahedronNodesIndex(tetrahedronNodeIds);
  }

  virtual bool isPointInsideCell(const MiGeometryI& meshGeometry, const MbVec3d &point, std::vector<double>& weights) const
  {
    return MxHexahedron20CellExtract::isPointInsideCell(meshGeometry,this,point,weights);
  }


protected:
  size_t m_nodeIds[20];
};


inline size_t 
WheelHexahedron20Cell::appendNodesIndexOfFacet (size_t facet, std::vector<size_t>& facetNodes) const
{
  std::vector<size_t> localFacetNode;
  MxHexahedron20CellExtract::getNodesIndexOfFacet(facet,localFacetNode);
  for (size_t i=0; i<localFacetNode.size(); ++i)
    facetNodes.push_back(m_nodeIds[localFacetNode[i]]);
  return localFacetNode.size();
}

#endif 


