#include "WheelTopology.h"
#include "WheelHexahedron20Cell.h"

using std::vector;

#include <Inventor/STL/cassert>

//---------------------------------------------------------------------------------------------------------------------
WheelTopology::WheelTopology(size_t numCellI, size_t numCellJ, size_t numCellK)
: m_numCellI(numCellI),
  m_numCellJ(numCellJ),
  m_numCellK(numCellK)
{
  m_numNodeI = 2*m_numCellI + 1;
  m_numNodeJ = 2*m_numCellJ + 1;
  m_numNodeK = 2*m_numCellK + 1;

  m_endNodeId =   m_numNodeI * m_numNodeJ * m_numNodeK;

  size_t i,j,k;
  size_t nodeId[20] = {0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0};
  
  for (i=0; i<m_numCellI; ++i)
  {
    for (j=0; j<m_numCellJ; ++j)
    {
      for (k=0; k<m_numCellK; ++k)
      {
        // linear nodes id
        nodeId[0]  = getNodeIndex(2*i   ,  2*j  , 2*k  );
        nodeId[1]  = getNodeIndex(2*i+2 ,  2*j  , 2*k  );
        nodeId[2]  = getNodeIndex(2*i+2 ,  2*j  , 2*k+2);
        nodeId[3]  = getNodeIndex(2*i   ,  2*j  , 2*k+2);

        nodeId[4]  = getNodeIndex(2*i   ,  2*j+2, 2*k  );
        nodeId[5]  = getNodeIndex(2*i+2 ,  2*j+2, 2*k  );
        nodeId[6]  = getNodeIndex(2*i+2 ,  2*j+2, 2*k+2);
        nodeId[7]  = getNodeIndex(2*i   ,  2*j+2, 2*k+2);

        // quad nodes id (on face j min)
        nodeId[8]  = getNodeIndex(2*i+1 ,  2*j  , 2*k  );
        nodeId[9]  = getNodeIndex(2*i+2 ,  2*j  , 2*k+1);
        nodeId[10] = getNodeIndex(2*i+1 ,  2*j  , 2*k+2);
        nodeId[11] = getNodeIndex(2*i   ,  2*j  , 2*k+1);

        // quad nodes id (on face j max)
        nodeId[12] = getNodeIndex(2*i+1 ,  2*j+2, 2*k  );
        nodeId[13] = getNodeIndex(2*i+2 ,  2*j+2, 2*k+1);
        nodeId[14] = getNodeIndex(2*i+1 ,  2*j+2, 2*k+2);
        nodeId[15] = getNodeIndex(2*i   ,  2*j+2, 2*k+1);

        // quad nodes id (on face j min+max/2)
        nodeId[16] = getNodeIndex(2*i   ,  2*j+1, 2*k  );
        nodeId[17] = getNodeIndex(2*i+2 ,  2*j+1, 2*k  );
        nodeId[18] = getNodeIndex(2*i+2 ,  2*j+1, 2*k+2);
        nodeId[19] = getNodeIndex(2*i   ,  2*j+1, 2*k+2);

        for (size_t kk=0; kk<20; ++kk)
          assert(nodeId[kk] < m_endNodeId);

        m_cells.push_back(WheelHexahedron20Cell(nodeId));
      }

    }
  }


}


