#ifndef  _WheelMesh_h
#define  _WheelMesh_h

#include <MeshVizXLM/mesh/MiVolumeMeshUnstructured.h>
#include <MeshVizXLM/mesh/data/MiDataSetI.h>

#include "WheelTetrahedron10Cell.h"
#include "WheelGeometry.h"
#include "WheelTopology.h"

#include <Inventor/SbBox.h>

#include <Inventor/STL/vector>

static double s_radiusMin = 3;
static double s_radiusMax = 8;
static double s_alpha0 = 0;
static double s_alpha1 = 3.1415927 *2;

static double s_beta0 = 40.0 * 3.1415927/180.0;
static double s_beta1 = -s_beta0;

//-----------------------------------------------------------------------------
class WheelMesh : public MiVolumeMeshUnstructured
{
public:
  WheelMesh(size_t numCellR, size_t numCellA, size_t numCellZ) :
    m_geometry(numCellR,numCellA,numCellZ),
    m_topology(numCellR,numCellA,numCellZ)
  {
    m_geometry.setGeometry(s_radiusMin,s_radiusMax, s_alpha0,s_alpha1, s_beta0,s_beta1 );
  }

  virtual const MiVolumeTopologyExplicitI& getTopology() const 
  {
    return m_topology;
  }

  virtual const MiGeometryI& getGeometry() const 
  {
    return m_geometry;
  }

  //const std::vector<MbVec3d>& getCoords() const
  //{
  //  return m_geometry.getCoords();
  //}


private:
  WheelGeometry m_geometry;
  WheelTopology m_topology;
};

#endif 


