#ifndef  _WheelTetrahedron10Cell_h
#define  _WheelTetrahedron10Cell_h

#include <MeshVizXLM/extractors/MxTetrahedron10CellExtract.h>
#include <MeshVizXLM/mesh/cell/MiVolumeCell.h>

#include <Inventor/STL/vector>

//-----------------------------------------------------------------------------
class WheelTetrahedron10Cell : public MiVolumeCell
{
public:
  WheelTetrahedron10Cell(size_t nodeId[10])
  {
    for (size_t i=0; i<10; ++i)
      m_nodeIds[i] = nodeId[i];
  }

  virtual size_t getNumEdges() const 
  {
    return 6;
  }

  virtual size_t getNumNodes() const 
  {
    return 10;
  }

  virtual size_t getNumFacets() const   {
    return 4;
  }

  /**
  * Gets the index (in the mesh) of a node
  * @param[in] node Node number (where: 0<= node < getNumNodes()).
  */
  virtual size_t getNodeIndex(size_t node) const 
  {
    return m_nodeIds[node];
  }

  virtual void getIsosurfTopology(unsigned char /*caseId*/, std::vector< std::pair<size_t,size_t> >& /*edgeList*/ ) const 
  {
  }

  virtual size_t appendNodesIndexOfFacet (size_t facet, std::vector<size_t>& facetNodes) const;

  virtual MbVec3d getIsoParametricCoord(size_t nodeIndex) const 
  {
    return MxTetrahedron10CellExtract::getIsoParametricCoord(nodeIndex);
  }

  //Reimplemented from MiCell 
  virtual void getWeight(const MbVec3d &ipcoord, std::vector<double>& weight) const
  {
    return MxTetrahedron10CellExtract::getWeight(ipcoord,weight);
  }

  virtual size_t getSubTriangleNodesIndex(size_t facet, std::vector<size_t>& triangleNodeIds) const 
  {
    return MxTetrahedron10CellExtract::getSubTriangleNodesIndex(facet,triangleNodeIds);
  }

  virtual size_t getSubTetrahedronNodesIndex (std::vector<size_t>& tetrahedronNodeIds) const 
  {
    return MxTetrahedron10CellExtract::getSubTetrahedronNodesIndex(tetrahedronNodeIds);
  }

  virtual bool isPointInsideCell(const MiGeometryI& meshGeometry, const MbVec3d &point, std::vector<double>& weights) const
  {
    return MxTetrahedron10CellExtract::isPointInsideCell(meshGeometry,this,point,weights);
  }


protected:
  size_t m_nodeIds[10];
  //static size_t s_facetNode[6][4];
};

#endif 


