#include "WheelTopology.h"
#include "WheelTetrahedron10Cell.h"

using std::vector;

#include <Inventor/STL/cassert>

//---------------------------------------------------------------------------------------------------------------------
WheelTopology::WheelTopology(size_t numCellI, size_t numCellJ, size_t numCellK)
: m_numCellI(numCellI),
  m_numCellJ(numCellJ),
  m_numCellK(numCellK)
{
  m_numNodeI = 2*m_numCellI + 1;
  m_numNodeJ = 2*m_numCellJ + 1;
  m_numNodeK = 2*m_numCellK + 1;

  m_endNodeId =   m_numNodeI * m_numNodeJ * m_numNodeK;

  size_t i,j,k;
  size_t hexaNodeId[27] = {0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,0,0,0};
  size_t tetraNodeId[60];
  
  for (i=0; i<m_numCellI; ++i)
  {
    for (j=0; j<m_numCellJ; ++j)
    {
      for (k=0; k<m_numCellK; ++k)
      {
        // linear nodes id
        hexaNodeId[0]  = getNodeIndex(2*i   ,  2*j  , 2*k  );
        hexaNodeId[1]  = getNodeIndex(2*i+2 ,  2*j  , 2*k  );
        hexaNodeId[2]  = getNodeIndex(2*i+2 ,  2*j  , 2*k+2);
        hexaNodeId[3]  = getNodeIndex(2*i   ,  2*j  , 2*k+2);

        hexaNodeId[4]  = getNodeIndex(2*i   ,  2*j+2, 2*k  );
        hexaNodeId[5]  = getNodeIndex(2*i+2 ,  2*j+2, 2*k  );
        hexaNodeId[6]  = getNodeIndex(2*i+2 ,  2*j+2, 2*k+2);
        hexaNodeId[7]  = getNodeIndex(2*i   ,  2*j+2, 2*k+2);

        // quad nodes id (on face j min)
        hexaNodeId[8]  = getNodeIndex(2*i+1 ,  2*j  , 2*k  );
        hexaNodeId[9]  = getNodeIndex(2*i+2 ,  2*j  , 2*k+1);
        hexaNodeId[10] = getNodeIndex(2*i+1 ,  2*j  , 2*k+2);
        hexaNodeId[11] = getNodeIndex(2*i   ,  2*j  , 2*k+1);

        // quad nodes id (on face j max)
        hexaNodeId[12] = getNodeIndex(2*i+1 ,  2*j+2, 2*k  );
        hexaNodeId[13] = getNodeIndex(2*i+2 ,  2*j+2, 2*k+1);
        hexaNodeId[14] = getNodeIndex(2*i+1 ,  2*j+2, 2*k+2);
        hexaNodeId[15] = getNodeIndex(2*i   ,  2*j+2, 2*k+1);

        // quad nodes id (on face j min+max/2)
        hexaNodeId[16] = getNodeIndex(2*i   ,  2*j+1, 2*k  );
        hexaNodeId[17] = getNodeIndex(2*i+2 ,  2*j+1, 2*k  );
        hexaNodeId[18] = getNodeIndex(2*i+2 ,  2*j+1, 2*k+2);
        hexaNodeId[19] = getNodeIndex(2*i   ,  2*j+1, 2*k+2);

        // quad nodes id (on internal face k min+max/2)
        hexaNodeId[20] = getNodeIndex(2*i+1 ,  2*j  , 2*k+1);
        hexaNodeId[21] = getNodeIndex(2*i+2 ,  2*j+1, 2*k+1);
        hexaNodeId[22] = getNodeIndex(2*i+1 ,  2*j+2, 2*k+1);
        hexaNodeId[23] = getNodeIndex(2*i   ,  2*j+1, 2*k+1);

        hexaNodeId[24] = getNodeIndex(2*i+1 ,  2*j+1, 2*k  );
        hexaNodeId[25] = getNodeIndex(2*i+1 ,  2*j+1, 2*k+2);
        hexaNodeId[26] = getNodeIndex(2*i+1 ,  2*j+1, 2*k+1);

        for (size_t kk=0; kk<27; ++kk)
          assert(hexaNodeId[kk] < m_endNodeId);

        splitHexaIn6Tetra(hexaNodeId,tetraNodeId);
        for ( size_t t=0; t < 6; ++t)
          m_cells.push_back(WheelTetrahedron10Cell(tetraNodeId+(t*10)));
      }

    }
  }


}


void WheelTopology::splitHexaIn6Tetra(size_t hexaNodes[27], size_t tetraNodes[60]) const
{
  size_t i=0;
  // first wedge
  // tetra 0,4,6,5
  tetraNodes[i++] = hexaNodes[0]; 
  tetraNodes[i++] = hexaNodes[4]; 
  tetraNodes[i++] = hexaNodes[6]; 
  tetraNodes[i++] = hexaNodes[5];
  tetraNodes[i++] = hexaNodes[16]; 
  tetraNodes[i++] = hexaNodes[22]; 
  tetraNodes[i++] = hexaNodes[26]; 
  tetraNodes[i++] = hexaNodes[24]; 
  tetraNodes[i++] = hexaNodes[12]; 
  tetraNodes[i++] = hexaNodes[13]; 
  // tetra 0,6,2,1,
  tetraNodes[i++] = hexaNodes[0]; 
  tetraNodes[i++] = hexaNodes[6]; 
  tetraNodes[i++] = hexaNodes[2]; 
  tetraNodes[i++] = hexaNodes[1];
  tetraNodes[i++] = hexaNodes[26];
  tetraNodes[i++] = hexaNodes[18];
  tetraNodes[i++] = hexaNodes[20];
  tetraNodes[i++] = hexaNodes[8];
  tetraNodes[i++] = hexaNodes[21];
  tetraNodes[i++] = hexaNodes[9];
  // tetra 0,1,5,6,
  tetraNodes[i++] = hexaNodes[0]; 
  tetraNodes[i++] = hexaNodes[1]; 
  tetraNodes[i++] = hexaNodes[5]; 
  tetraNodes[i++] = hexaNodes[6];
  tetraNodes[i++] = hexaNodes[8];
  tetraNodes[i++] = hexaNodes[17];
  tetraNodes[i++] = hexaNodes[24];
  tetraNodes[i++] = hexaNodes[26];
  tetraNodes[i++] = hexaNodes[21];
  tetraNodes[i++] = hexaNodes[13];
  //  // second wedge
  // tetra 0,6,4,7,
  tetraNodes[i++] = hexaNodes[0]; 
  tetraNodes[i++] = hexaNodes[6]; 
  tetraNodes[i++] = hexaNodes[4]; 
  tetraNodes[i++] = hexaNodes[7];
  tetraNodes[i++] = hexaNodes[26];
  tetraNodes[i++] = hexaNodes[22];
  tetraNodes[i++] = hexaNodes[16];
  tetraNodes[i++] = hexaNodes[23];
  tetraNodes[i++] = hexaNodes[14];
  tetraNodes[i++] = hexaNodes[15];
  // tetra 0,2,6,3,
  tetraNodes[i++] = hexaNodes[0]; 
  tetraNodes[i++] = hexaNodes[2]; 
  tetraNodes[i++] = hexaNodes[6]; 
  tetraNodes[i++] = hexaNodes[3];
  tetraNodes[i++] = hexaNodes[20];
  tetraNodes[i++] = hexaNodes[18];
  tetraNodes[i++] = hexaNodes[26];
  tetraNodes[i++] = hexaNodes[11];
  tetraNodes[i++] = hexaNodes[10];
  tetraNodes[i++] = hexaNodes[25];
  // tetra 0,7,3,6
  tetraNodes[i++] = hexaNodes[0]; 
  tetraNodes[i++] = hexaNodes[7]; 
  tetraNodes[i++] = hexaNodes[3]; 
  tetraNodes[i++] = hexaNodes[6];
  tetraNodes[i++] = hexaNodes[23];
  tetraNodes[i++] = hexaNodes[19];
  tetraNodes[i++] = hexaNodes[11];
  tetraNodes[i++] = hexaNodes[26];
  tetraNodes[i++] = hexaNodes[14];
  tetraNodes[i++] = hexaNodes[25];
}

