#ifndef  _WheelGeometry_h
#define  _WheelGeometry_h

#include <MeshVizXLM/mesh/geometry/MiGeometryI.h>

#include <Inventor/SbBox.h>

#include <Inventor/STL/vector>

//-----------------------------------------------------------------------------
class WheelGeometry : public MiGeometryI
{
public:
  WheelGeometry(size_t numCellR, size_t numCellA, size_t numCellB);
  const std::vector<MbVec3d>& getCoords() const
  {
    return m_coords;
  }

  void setGeometry(double rmin, double rmax, double alphaMin, double alphaMax, double zMin, double zMax);

  virtual MbVec3d getCoord(size_t i) const 
  {
    return m_coords[i];
  }

  virtual MbVec3d getMin() const 
  {
    return MbVec3d(m_bbox.getMin());
  }
  /**
  * Returns the maximum value of this set.
  */
  virtual MbVec3d getMax() const 
  {
    return MbVec3d(m_bbox.getMax());
  }


  virtual size_t getTimeStamp() const 
  {
    return 1;
  }

private:
  MbVec3d getCartesianCoord(double r, double a, double b)
  {
    return MbVec3d(r*cos(a)*cos(b),r*sin(b),r*cos(b)*sin(a));
  }

  size_t m_numNodeR, m_numNodeA, m_numNodeB;
  std::vector<MbVec3d> m_coords;

  SbBox3d m_bbox;
};


#endif 


