#ifndef  _WheelMesh_h
#define  _WheelMesh_h

#include <MeshVizXLM/mesh/MiVolumeMeshUnstructured.h>
#include <MeshVizXLM/mesh/data/MiDataSetI.h>

#include "WheelWedge18Cell.h"
#include "WheelGeometry.h"
#include "WheelTopology.h"

#include <Inventor/SbBox.h>

#include <Inventor/STL/vector>

//-----------------------------------------------------------------------------
class WheelMesh : public MiVolumeMeshUnstructured
{
public:
  WheelMesh(size_t numCellR, size_t numCellA, size_t numCellZ,
            double radiusMin, double radiusMax, 
            double alpha0, double alpha1, 
            double beta0, double beta1
  ) :
    m_geometry(numCellR,numCellA,numCellZ),
    m_topology(numCellR,numCellA,numCellZ)
  {
    m_geometry.setGeometry(radiusMin,radiusMax, alpha0,alpha1, beta0,beta1 );
  }

  virtual const MiVolumeTopologyExplicitI& getTopology() const 
  {
    return m_topology;
  }

  virtual const MiGeometryI& getGeometry() const 
  {
    return m_geometry;
  }

private:
  WheelGeometry m_geometry;
  WheelTopology m_topology;
};

#endif 


