#include "WheelTopology.h"
#include "WheelWedge18Cell.h"

using std::vector;

#include <Inventor/STL/cassert>

//---------------------------------------------------------------------------------------------------------------------
WheelTopology::WheelTopology(size_t numCellI, size_t numCellJ, size_t numCellK)
: m_numCellI(numCellI),
  m_numCellJ(numCellJ),
  m_numCellK(numCellK)
{
  m_numNodeI = 2*m_numCellI + 1;
  m_numNodeJ = 2*m_numCellJ + 1;
  m_numNodeK = 2*m_numCellK + 1;

  m_endNodeId =   m_numNodeI * m_numNodeJ * m_numNodeK;

  size_t i,j,k;
  size_t hexaNodeId[27] = {0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,0,0,0};
  size_t wedgeNodeId[18];
  
  for (i=0; i<m_numCellI; ++i)
  {
    for (j=0; j<m_numCellJ; ++j)
    {
      for (k=0; k<m_numCellK; ++k)
      {
        // linear nodes id
        hexaNodeId[0]  = getNodeIndex(2*i   ,  2*j  , 2*k  );
        hexaNodeId[1]  = getNodeIndex(2*i+2 ,  2*j  , 2*k  );
        hexaNodeId[2]  = getNodeIndex(2*i+2 ,  2*j  , 2*k+2);
        hexaNodeId[3]  = getNodeIndex(2*i   ,  2*j  , 2*k+2);

        hexaNodeId[4]  = getNodeIndex(2*i   ,  2*j+2, 2*k  );
        hexaNodeId[5]  = getNodeIndex(2*i+2 ,  2*j+2, 2*k  );
        hexaNodeId[6]  = getNodeIndex(2*i+2 ,  2*j+2, 2*k+2);
        hexaNodeId[7]  = getNodeIndex(2*i   ,  2*j+2, 2*k+2);

        // quad nodes id (on face j min)
        hexaNodeId[8]  = getNodeIndex(2*i+1 ,  2*j  , 2*k  );
        hexaNodeId[9]  = getNodeIndex(2*i+2 ,  2*j  , 2*k+1);
        hexaNodeId[10] = getNodeIndex(2*i+1 ,  2*j  , 2*k+2);
        hexaNodeId[11] = getNodeIndex(2*i   ,  2*j  , 2*k+1);

        // quad nodes id (on face j max)
        hexaNodeId[12] = getNodeIndex(2*i+1 ,  2*j+2, 2*k  );
        hexaNodeId[13] = getNodeIndex(2*i+2 ,  2*j+2, 2*k+1);
        hexaNodeId[14] = getNodeIndex(2*i+1 ,  2*j+2, 2*k+2);
        hexaNodeId[15] = getNodeIndex(2*i   ,  2*j+2, 2*k+1);

        // quad nodes id (on face j min+max/2)
        hexaNodeId[16] = getNodeIndex(2*i   ,  2*j+1, 2*k  );
        hexaNodeId[17] = getNodeIndex(2*i+2 ,  2*j+1, 2*k  );
        hexaNodeId[18] = getNodeIndex(2*i+2 ,  2*j+1, 2*k+2);
        hexaNodeId[19] = getNodeIndex(2*i   ,  2*j+1, 2*k+2);

        // quad nodes id (on internal face k min+max/2)
        hexaNodeId[20] = getNodeIndex(2*i+1 ,  2*j  , 2*k+1);
        hexaNodeId[21] = getNodeIndex(2*i+2 ,  2*j+1, 2*k+1);
        hexaNodeId[22] = getNodeIndex(2*i+1 ,  2*j+2, 2*k+1);
        hexaNodeId[23] = getNodeIndex(2*i   ,  2*j+1, 2*k+1);

        hexaNodeId[24] = getNodeIndex(2*i+1 ,  2*j+1, 2*k  );
        hexaNodeId[25] = getNodeIndex(2*i+1 ,  2*j+1, 2*k+2);
        hexaNodeId[26] = getNodeIndex(2*i+1 ,  2*j+1, 2*k+1);

        for (size_t kk=0; kk<27; ++kk)
          assert(hexaNodeId[kk] < m_endNodeId);

        wedgeNodeId[0] = hexaNodeId[0];
        wedgeNodeId[1] = hexaNodeId[1];
        wedgeNodeId[2] = hexaNodeId[3];
        wedgeNodeId[3] = hexaNodeId[4];
        wedgeNodeId[4] = hexaNodeId[5];
        wedgeNodeId[5] = hexaNodeId[7];
        wedgeNodeId[6] = hexaNodeId[8];
        wedgeNodeId[7] = hexaNodeId[20];
        wedgeNodeId[8] = hexaNodeId[11];
        wedgeNodeId[9] = hexaNodeId[12];
        wedgeNodeId[10] = hexaNodeId[22];
        wedgeNodeId[11] = hexaNodeId[15];
        wedgeNodeId[12] = hexaNodeId[16];
        wedgeNodeId[13] = hexaNodeId[17];
        wedgeNodeId[14] = hexaNodeId[19];
        wedgeNodeId[15] = hexaNodeId[24];
        wedgeNodeId[16] = hexaNodeId[26];
        wedgeNodeId[17] = hexaNodeId[23];

        m_cells.push_back(WheelWedge18Cell(wedgeNodeId));

        //wedgeNodeId[0] = hexaNodeId[2];
        //wedgeNodeId[1] = hexaNodeId[3];
        //wedgeNodeId[2] = hexaNodeId[1];
        //wedgeNodeId[3] = hexaNodeId[6];
        //wedgeNodeId[4] = hexaNodeId[7];
        //wedgeNodeId[5] = hexaNodeId[5];
        //wedgeNodeId[6] = hexaNodeId[10];
        //wedgeNodeId[7] = hexaNodeId[20];
        //wedgeNodeId[8] = hexaNodeId[ 9];
        //wedgeNodeId[9] = hexaNodeId[14];
        //wedgeNodeId[10] = hexaNodeId[22];
        //wedgeNodeId[11] = hexaNodeId[13];
        //wedgeNodeId[12] = hexaNodeId[18];
        //wedgeNodeId[13] = hexaNodeId[19];
        //wedgeNodeId[14] = hexaNodeId[17];
        //wedgeNodeId[15] = hexaNodeId[25];
        //wedgeNodeId[16] = hexaNodeId[26];
        //wedgeNodeId[17] = hexaNodeId[21];

        //m_cells.push_back(WheelWedge18Cell(wedgeNodeId));

      }

    }
  }


}

