#include <MbSampleMeshBuilder.h>

#include <MeshVizXLM/mapping/MoMeshViz.h>
#include <MeshVizXLM/mapping/nodes/MoMesh.h>
#include <MeshVizXLM/mapping/nodes/MoScalarSetI.h>
#include <MeshVizXLM/mapping/nodes/MoPredefinedColorMapping.h>
#include <MeshVizXLM/mapping/nodes/MoMeshLine.h>
#include <MeshVizXLM/mapping/nodes/MoMeshSurface.h>

#include <MeshVizXLM/extractors/MiIsolineExtractIj.h>

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>

#include <Inventor/STL/iostream>
#include <Inventor/STL/vector>
using namespace std;

#define NAMESTR "MeshVizXLM displaying a line mesh stored in the scene graph"

#if defined(_MSC_VER)
#pragma warning( push )
#pragma warning(disable:4250)
#endif

//-----------------------------------------------------------------------------
int
main(int, char **)
{
  // Build a sample line mesh
  MbSampleMeshBuilder<MbVec3f,float> meshBuilder2;
  MbLineMeshUnstructured<MbVec3f,float,MbVec3f>& mesh = meshBuilder2.getLineMeshUnstructured(100,MbVec3f(0,0,0),MbVec3f(100,100,100),MbSinGeomFunctor());

  // Init viewer
  Widget my_window = SoXt::init(NAMESTR) ;
  if (my_window == NULL) exit(1) ;

  MoMeshViz::init();

  SoSeparator* sep = new SoSeparator;
  
  SoShapeHints * sh = new SoShapeHints;
  sh->vertexOrdering.setValue(SoShapeHints::CLOCKWISE);
  sep->addChild(sh);

  // Color map
  MoPredefinedColorMapping* colMap = new MoPredefinedColorMapping;
  colMap->minValue = (float)mesh.getScalarSet("$MyScalarSet")->getMin();
  colMap->maxValue = (float)mesh.getScalarSet("$MyScalarSet")->getMax();
  colMap->predefColorMap = MoPredefinedColorMapping::STANDARD;
  sep->addChild(colMap);

  // Scalar Value
  MoScalarSetI *scalarNode = new MoScalarSetI;
  scalarNode->setScalarSet(mesh.getScalarSet("$MyScalarSet"));
  sep->addChild(scalarNode);

  // Display the surface mesh
  MoMesh* moMesh = new MoMesh;
  moMesh->setMesh(&mesh);
  sep->addChild(moMesh);

  SoDrawStyle* style = new SoDrawStyle;
  style->lineWidth = 3;
  sep->addChild(style);

  MoMeshLine *line = new MoMeshLine;
  // Use first MoScalarSetI from the state
  line->colorScalarSetId = 0;
  sep->addChild(line);

  SoXtExaminerViewer* viewer = new SoXtExaminerViewer(my_window);
  viewer->setSceneGraph(sep);
  viewer->setSize(SbVec2s(1024,768));
  viewer->show();
  viewer->viewAll();

  // dialog
  SoXt::show(my_window);
  SoXt::mainLoop();

  delete viewer;
  MoMeshViz::finish();
  SoXt::finish();

  return 0;
}

#if defined(_MSC_VER)
#pragma warning( pop ) 
#endif

