#include <MbSampleMeshBuilder.h>

#include <MeshVizXLM/mapping/MoMeshViz.h>
#include <MeshVizXLM/mapping/nodes/MoMesh.h>
#include <MeshVizXLM/mapping/nodes/MoScalarSetIj.h>
#include <MeshVizXLM/mapping/nodes/MoPredefinedColorMapping.h>
#include <MeshVizXLM/mapping/nodes/MoMeshSurface.h>
#include <MeshVizXLM/mapping/nodes/MoMaterial.h>

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoEventCallback.h>
#include <Inventor/nodes/SoCallback.h>
#include <Inventor/events/SoKeyboardEvent.h> 

#include <Inventor/STL/iostream>
#include <Inventor/STL/vector>
using namespace std;

#define NAMESTR "MeshVizXLM displaying a sample mesh "

#ifdef _MSC_VER
#pragma warning( push )
#pragma warning(disable:4250)
#endif

void
editEnhancedColoring(void *userData, SoEventCallback *eventCB)
{
  const SoEvent *ev = eventCB->getEvent();
  MoMaterial* mat = (MoMaterial*) userData;
  if (mat)
  {
    if (SO_KEY_PRESS_EVENT(ev, F1)) 
    {
      mat->enhancedColoring = mat->enhancedColoring.getValue() == FALSE ? TRUE : FALSE ;
      if (mat->enhancedColoring.getValue() == TRUE)
        std::cout << "Enhanced Coloring ON" << std::endl;
      else 
        std::cout << "Enhanced Coloring OFF" << std::endl;
    }
  }
}

//-----------------------------------------------------------------------------
int
main(int, char **)
{
#define DATASET 2
  MbSampleMeshBuilder<MbVec3f,float> meshBuilder;
  MbSurfaceMeshCurvilinear<MbVec3f,float,MbVec3f>& mesh = meshBuilder.getSurfaceMeshCurvilinear(10,10,MbVec3f(0,0,0),MbVec3f(1,0,0),MbVec3f(0,1,0));
    
  std::cout << "Press F1 for toggling enhanced coloring" << std::endl;

  // Init viewer
  Widget my_window = SoXt::init(NAMESTR) ;
  if (my_window == NULL) exit(1) ;

  MoMeshViz::init();

  SoSeparator* sep = new SoSeparator;
  
  SoShapeHints * sh = new SoShapeHints;
  sh->vertexOrdering.setValue(SoShapeHints::CLOCKWISE);
  sep->addChild(sh);

  MoMesh* moMesh = new MoMesh;
  moMesh->setMesh(&mesh);
  sep->addChild(moMesh);

  MoPredefinedColorMapping* colMap = new MoPredefinedColorMapping;
  colMap->minValue = (float)mesh.getScalarSet(DATASET)->getMin();
  colMap->maxValue = (float)mesh.getScalarSet(DATASET)->getMax();
  colMap->predefColorMap = MoPredefinedColorMapping::STANDARD;
  sep->addChild(colMap);

  // Scalar Value
  MoScalarSetIj *MoScalarSetIj2 = new MoScalarSetIj;
  MoScalarSetIj2->setScalarSet(mesh.getScalarSet(DATASET));
  sep->addChild(MoScalarSetIj2);

  // Turns on Enhanced Coloring to hide tesselation artefacts
  MoMaterial* material = new MoMaterial;
  material->enhancedColoring = TRUE;
  sep->addChild(material);

  SoEventCallback *myCallbackNode = new SoEventCallback;
  myCallbackNode->addEventCallback(SoKeyboardEvent::getClassTypeId(), editEnhancedColoring, material); 
  sep->addChild(myCallbackNode);


  MoMeshSurface *surface = new MoMeshSurface;
  surface->colorScalarSetId = 0;
  sep->addChild(surface);

  SoXtExaminerViewer* viewer = new SoXtExaminerViewer(my_window);
  viewer->setSceneGraph(sep);
  viewer->setSize(SbVec2s(1024,768));
  viewer->show();
  viewer->viewAll();

  // dialog
  SoXt::show(my_window);
  SoXt::mainLoop();

  delete viewer;
  MoMeshViz::finish();
  SoXt::finish();

  return 0;
}

#ifdef _MSC_VER
#pragma warning( pop ) 
#endif

